package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.util.concurrent.Promise;


/**
 * {@link com.atlassian.confluence.api.service.search.CQLSearchService} implementation that communicates with Confluence remotely using the Confluence REST API.
 *
 * Provides promise returning equivalents for the methods in CQLSearchService.
 */
public interface RemoteCQLSearchService
{
    @SuppressWarnings(value="unused")
    Promise<PageResponse<Content>> searchContent(String cql, PageRequest request, Expansion... expansions);

    @SuppressWarnings(value="unused")
    Promise<PageResponse<Content>> searchContent(String cql, Expansion... expansions);

    @SuppressWarnings(value="unused")
    int countContent(String cql);
}
