/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.authentication;

import com.atlassian.annotations.ExperimentalApi;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

@ExperimentalApi
public class AuthenticatedWebResourceProvider {
    private final String restApiBaseUrl;
    private final Client client;
    private String username;
    private char[] password;

    public AuthenticatedWebResourceProvider(Client client, String baseUrl, String path) {
        this.client = client;
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.restApiBaseUrl = baseUrl + path;
    }

    public WebResource newRestWebResource() {
        URI uri = UriBuilder.fromUri((String)this.restApiBaseUrl).build(new Object[0]);
        WebResource resource = this.client.resource(uri);
        if (this.username != null) {
            assert (this.password != null);
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, new String(this.password)));
        }
        return resource;
    }

    public WebResource.Builder newJsonResource(String path) {
        return this.newRestWebResource().path(path).type("application/json");
    }

    public void setAuthContext(String username, char[] password) {
        this.username = username;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
        this.password = password;
    }

    public void clearAuthContext() {
        this.setAuthContext(null, null);
    }

    public String getUsername() {
        return this.username;
    }
}

