/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExceptionConverter;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.PromisingExecutorService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteService<P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteService.class);
    private AuthenticatedWebResourceProvider provider;
    private final PromisingExecutorService executor;

    protected AbstractRemoteService(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        this.provider = provider;
        this.executor = new PromisingExecutorService(executor);
    }

    protected AbstractRemoteService(AbstractRemoteService other) {
        this.provider = other.provider;
        this.executor = other.executor;
    }

    protected WebResource newRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("api");
    }

    protected WebResource newExperimentalRestWebResource() {
        return this.provider.newRestWebResource().path("rest").path("experimental");
    }

    protected <T> Promise<Option<T>> getFutureOption(final WebResource resource, final Class<? extends T> entityClass) {
        return this.executor.submit(new Callable<Option<T>>(){

            @Override
            public Option<T> call() throws Exception {
                return AbstractRemoteService.this.getOption(resource, entityClass);
            }
        });
    }

    protected <E> Promise<PageResponse<E>> getFuturePageResponseList(final WebResource resource, final Class<E> contentClass) {
        return this.executor.submit(new Callable<PageResponse<E>>(){

            @Override
            public PageResponse<E> call() throws Exception {
                return AbstractRemoteService.this.getPartialList(resource, contentClass);
            }
        });
    }

    protected <K, V> Promise<Map<K, PageResponse<V>>> getFutureMapOfPageResponses(WebResource resource, Class<K> keyClass, Class<V> listContentClass) {
        GenericType<Map> mapType = this.getGenericType(Map.class, keyClass, AbstractRemoteService.getParameterizedType(RestList.class, listContentClass));
        Promise<Map> promise = this.getFutureGenericMap(resource, mapType);
        return promise;
    }

    private <K, V> Promise<Map> getFutureGenericMap(final WebResource resource, final GenericType<Map> mapType) {
        return this.executor.submit(new Callable<Map>(){

            @Override
            public Map call() throws Exception {
                try {
                    return Maps.filterEntries((Map)((Map)resource.get(mapType)), (Predicate)new Predicate<Object>(){

                        public boolean apply(@Nullable Object input) {
                            return !input.toString().startsWith("_");
                        }
                    });
                }
                catch (UniformInterfaceException e) {
                    throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
                }
            }
        });
    }

    protected <E> Promise<? extends Iterable<E>> getFutureGenericCollection(final WebResource resource, final Class<? extends Iterable> collectionType, final Class<E> contentType) {
        return this.executor.submit(new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return AbstractRemoteService.this.getGenericIterable(resource, collectionType, contentType);
            }
        });
    }

    protected <E> Promise<E> postFuture(WebResource resource, Class<? extends E> entityClass, Object postEntity) {
        return this.postFuture(resource, entityClass, postEntity, MediaType.APPLICATION_JSON_TYPE);
    }

    protected <E> Promise<E> postFuture(final WebResource resource, final Class<? extends E> entityClass, final Object postEntity, final MediaType mediaType) {
        return this.executor.submit(new Callable<E>(){

            @Override
            public E call() throws Exception {
                return AbstractRemoteService.this.post(resource, entityClass, postEntity, mediaType);
            }
        });
    }

    protected <E> Promise<E> postFuture(final WebResource resource, final Class<E> collectionClass, final Class contentType, final Object postEntity) {
        return this.executor.submit(new Callable<E>(){

            @Override
            public E call() throws Exception {
                return AbstractRemoteService.this.post(resource, collectionClass, contentType, postEntity);
            }
        });
    }

    protected <T> Promise<PageResponse<T>> postFutureToPageResponse(final WebResource resource, final Class<T> entityClass, final Object postEntity, final MediaType mediaType) {
        return this.executor.submit(new Callable<PageResponse<T>>(){

            @Override
            public PageResponse<T> call() throws Exception {
                return AbstractRemoteService.this.postToPageResponse(resource, entityClass, postEntity, mediaType);
            }
        });
    }

    protected <T> Promise<T> putFuture(final WebResource resource, final Class<? extends T> entityClass, final Object putEntity) {
        return this.executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractRemoteService.this.put(resource, entityClass, putEntity);
            }
        });
    }

    protected Promise<Void> deleteFuture(WebResource resource) {
        return this.deleteFuture(resource, Void.class);
    }

    protected <T> Promise<T> deleteFuture(final WebResource resource, final Class<? extends T> responseClass) {
        return this.executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractRemoteService.this.delete(resource, responseClass);
            }
        });
    }

    protected WebResource addExpansions(WebResource resource, Expansion[] expansions) {
        if (expansions.length == 0) {
            return resource;
        }
        return resource.queryParam("expand", ExpansionsParser.asString((Expansion[])expansions));
    }

    protected WebResource addPageRequestParams(WebResource resource, @Nullable PageRequest request) {
        if (request == null) {
            return resource;
        }
        return resource.queryParam("start", Integer.toString(request.getStart())).queryParam("limit", Integer.toString(request.getLimit()));
    }

    private <E> Option<E> getOption(WebResource resource, Class<? extends E> clazz) throws ServiceException {
        try {
            Object entity = resource.get(clazz);
            return Option.some((Object)entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                log.debug("404 being converted to Option.none : {}", (Object)e.getMessage());
                return Option.none();
            }
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <E> PageResponse<E> getPartialList(WebResource resource, Class<E> contentClass) throws ServiceException {
        return (PageResponse)this.getGenericIterable(resource, RestList.class, contentClass);
    }

    private <G> GenericType<G> getGenericType(Class<G> collectionType, Type ... typeParameters) {
        return new GenericType((Type)AbstractRemoteService.getParameterizedType(collectionType, typeParameters));
    }

    private static ParameterizedType getParameterizedType(final Class type, final Type ... typeParameters) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeParameters;
            }

            @Override
            public Type getRawType() {
                return type;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private <T> Iterable<T> getGenericIterable(WebResource resource, Class<? extends Iterable> collectionType, Class<T> contentClass) throws ServiceException {
        try {
            return (Iterable)resource.get(this.getGenericType(collectionType, contentClass));
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> PageResponse<T> postToPageResponse(WebResource resource, final Class<T> contentClass, Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            ParameterizedType restListType = new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{contentClass};
                }

                @Override
                public Type getRawType() {
                    return RestList.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (PageResponse)builder.post(new GenericType((Type)restListType), postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> T post(WebResource resource, Class<? extends T> clazz, Object postEntity, MediaType mediaType) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(mediaType);
            this.setAtlassianTokenIfNeeded(builder, mediaType);
            return (T)builder.post(clazz, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> T post(WebResource resource, Class<T> collectionType, Class contentClass, Object postEntity) throws ServiceException {
        try {
            GenericType<T> type = this.getGenericType(collectionType, contentClass);
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).post(type, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private void setAtlassianTokenIfNeeded(WebResource.Builder builder, MediaType mediaType) {
        if (mediaType != MediaType.APPLICATION_JSON_TYPE) {
            builder.header("X-Atlassian-Token", (Object)"nocheck");
        }
    }

    private <T> T put(WebResource resource, Class<? extends T> clazz, Object putEntity) throws ServiceException {
        try {
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).put(clazz, putEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> T delete(WebResource resource, Class<? extends T> clazz) throws ServiceException {
        try {
            WebResource.Builder builder = resource.type(MediaType.APPLICATION_JSON_TYPE);
            if (clazz == Void.class) {
                builder.delete();
                return null;
            }
            return (T)builder.delete(clazz);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    protected WebResource addPageRequest(WebResource resource, PageRequest pageRequest) {
        return this.addPageRequestParams(resource, pageRequest);
    }
}

