/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class RemoteContentServiceImpl
extends AbstractRemoteService<ContentService>
implements RemoteContentService {
    public RemoteContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, (ExecutorService)executor);
    }

    @Override
    public Future<Option<Content>> findById(String contentId, Expansion ... expansions) {
        WebResource resource = this.newRestWebResource().path("content").path(contentId);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureOption(resource, Content.class);
    }

    @Override
    public Future<Option<Content>> find(ContentLocator locator, Expansion ... expansions) {
        WebResource resource = this.newRestWebResource().path("content");
        ContentType[] contentTypes = locator.getContentTypes();
        if (contentTypes.length == 1) {
            ContentType contentType = contentTypes[0];
            resource = resource.queryParam("type", contentType.getType());
            if (contentType == ContentType.BLOG_POST) {
                resource = resource.queryParam("postingDay", locator.getPostingDay().toString("yyyy-MM-dd"));
            }
        }
        resource = resource.queryParam("spaceKey", locator.getSpaceKey());
        resource = resource.queryParam("title", locator.getTitle());
        resource = this.addExpansions(resource, expansions);
        return this.getFutureOption(resource, Content.class);
    }

    @Override
    public Future<Content> create(Content newContent) throws ServiceException {
        WebResource resource = this.newRestWebResource().path("content");
        return this.postFuture(resource, Content.class, newContent);
    }

    @Override
    public Future<Content> update(Content content) throws ServiceException {
        WebResource resource = this.newRestWebResource().path("content").path(content.getId());
        return this.putFuture(resource, Content.class, content);
    }

    @Override
    public Future<Void> delete(Content content) throws ServiceException {
        WebResource resource = this.newRestWebResource().path("content").path(content.getId());
        return this.deleteFuture(resource);
    }
}

