/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentMacroService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import javax.annotation.Nullable;

public class RemoteContentMacroServiceImpl
extends AbstractRemoteService<ContentMacroService>
implements RemoteContentMacroService {
    private RemoteContentServiceImpl contentService;

    public RemoteContentMacroServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
        this.contentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public RemoteContentMacroService.RemoteMacroFinder findInContent(ContentId content, Expansion ... expansions) {
        return new RemoteMacroFinderImpl(this, content);
    }

    public class RemoteMacroFinderImpl
    extends AbstractRemoteService<ContentMacroService.MacroInstanceFinder>
    implements RemoteContentMacroService.RemoteMacroFinder {
        private final ContentId contentId;
        private String hash;
        private int versionNumber;

        protected RemoteMacroFinderImpl(AbstractRemoteService otherService, ContentId contentId) {
            super(otherService);
            this.contentId = contentId;
        }

        @Override
        public RemoteContentMacroService.RemoteMacroFinder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        @Override
        public RemoteContentMacroService.RemoteMacroFinder withContentVersion(int versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Promise<Option<MacroInstance>> fetchOne() {
            WebResource resource = RemoteContentMacroServiceImpl.this.contentService.newContentWebResource().path(this.contentId.serialise()).path("history").path(Integer.toString(this.versionNumber)).path("macro").path("hash").path(this.hash);
            return this.getFutureOption(resource, MacroInstance.class);
        }

        @Override
        public Promise<MacroInstance> fetchOneOrNull() {
            return this.fetchOne().map((Function)new Function<Option<MacroInstance>, MacroInstance>(){

                public MacroInstance apply(@Nullable Option<MacroInstance> input) {
                    return (MacroInstance)input.getOrNull();
                }
            });
        }
    }
}

