/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExceptionConverter;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;

public abstract class AbstractRemoteService<T> {
    private AuthenticatedWebResourceProvider provider;
    private final ExecutorService executor;

    protected AbstractRemoteService(AuthenticatedWebResourceProvider provider, ExecutorService executor) {
        this.provider = provider;
        this.executor = executor;
    }

    protected WebResource newRestWebResource() {
        return this.provider.newRestWebResource();
    }

    protected <T> Future<Option<T>> getFutureOption(final WebResource resource, final Class<? extends T> entityClass) {
        return this.executor.submit(new Callable<Option<T>>(){

            @Override
            public Option<T> call() throws Exception {
                return AbstractRemoteService.this.getOption(resource, entityClass);
            }
        });
    }

    protected <T> Future<PageResponse<T>> getFuturePageResponseList(final WebResource resource, final Class<T> contentClass) {
        return this.executor.submit(new Callable<PageResponse<T>>(){

            @Override
            public PageResponse<T> call() throws Exception {
                return AbstractRemoteService.this.getPartialList(resource, contentClass);
            }
        });
    }

    protected <T> Future<T> postFuture(final WebResource resource, final Class<? extends T> entityClass, final Object postEntity) {
        return this.executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractRemoteService.this.post(resource, entityClass, postEntity);
            }
        });
    }

    protected <T> Future<T> putFuture(final WebResource resource, final Class<? extends T> entityClass, final Object putEntity) {
        return this.executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AbstractRemoteService.this.put(resource, entityClass, putEntity);
            }
        });
    }

    protected Future<Void> deleteFuture(final WebResource resource) {
        return this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return AbstractRemoteService.this.delete(resource);
            }
        });
    }

    private <T> Option<T> getOption(WebResource resource, Class<? extends T> clazz) throws ServiceException {
        try {
            Object entity = resource.get(clazz);
            return Option.some((Object)entity);
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                return Option.none();
            }
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> PageResponse<T> getPartialList(WebResource resource, final Class<T> contentClass) throws ServiceException {
        try {
            ParameterizedType restListType = new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{contentClass};
                }

                @Override
                public Type getRawType() {
                    return RestList.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
            return (PageResponse)resource.get(new GenericType((Type)restListType));
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                return PageResponseImpl.empty((boolean)false);
            }
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> T post(WebResource resource, Class<? extends T> clazz, Object postEntity) throws ServiceException {
        try {
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).post(clazz, postEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private <T> T put(WebResource resource, Class<? extends T> clazz, Object putEntity) throws ServiceException {
        try {
            return (T)resource.type(MediaType.APPLICATION_JSON_TYPE).put(clazz, putEntity);
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    private Void delete(WebResource resource) throws ServiceException {
        try {
            resource.type(MediaType.APPLICATION_JSON_TYPE).delete();
            return null;
        }
        catch (UniformInterfaceException e) {
            throw ExceptionConverter.Client.convertToServiceException((UniformInterfaceException)e);
        }
    }

    protected WebResource addExpansions(WebResource resource, Expansion[] expansions) {
        if (expansions.length == 0) {
            return resource;
        }
        return resource.queryParam("expand", ExpansionsParser.asString((Expansion[])expansions));
    }
}

