/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client.authentication;

import com.atlassian.annotations.ExperimentalApi;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

@ExperimentalApi
public class AuthenticatedWebResourceProvider {
    private final String restApiBaseUrl;
    private final Client client;
    private String username;
    private char[] password;

    public AuthenticatedWebResourceProvider(Client client, String baseUrl) {
        this.client = client;
        this.restApiBaseUrl = baseUrl + "/rest/api/1";
    }

    public WebResource newRestWebResource() {
        URI uri = UriBuilder.fromUri((String)this.restApiBaseUrl).build(new Object[0]);
        WebResource resource = this.client.resource(uri);
        if (this.username != null) {
            assert (this.password != null);
            resource = resource.queryParam("os_username", this.username);
            resource = resource.queryParam("os_password", new String(this.password));
        }
        return resource;
    }

    public void setAuthContext(String username, char[] password) {
        this.username = username;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
        this.password = password;
    }

    public void clearAuthContext() {
        this.setAuthContext(null, null);
    }
}

