/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteChildContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import javax.annotation.Nullable;

public class RemoteChildContentServiceImpl
extends AbstractRemoteService<ChildContentService>
implements RemoteChildContentService {
    public RemoteChildContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteChildContentService.RemoteChildContentFinder findContent(ContentId parentId, Expansion ... expansion) {
        return new RemoteChildContentFinderImpl(this, parentId, expansion);
    }

    public static class RemoteChildContentFinderImpl
    extends AbstractRemoteService<ChildContentService.ChildContentFinder>
    implements RemoteChildContentService.RemoteChildContentFinder {
        private WebResource resource;
        private Depth depth = Depth.ROOT;

        public RemoteChildContentFinderImpl(AbstractRemoteService other, ContentId parentId, Expansion[] expansion) {
            super(other);
            this.resource = this.newRestWebResource().path("content").path(parentId.serialise());
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(@Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, @Nullable PageRequest request) {
            this.resource = this.resource.path(this.getPathEndForDepth());
            this.resource = this.resource.path(type.getType().toLowerCase());
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteChildContentService.RemoteChildContentFinder withDepth(Depth depth) {
            this.depth = depth;
            return this;
        }

        private String getPathEndForDepth() {
            if (this.depth == Depth.ROOT) {
                return "child";
            }
            throw new NotImplementedServiceException("Only ROOT depth is currently supported - descendant resource coming soon.");
        }

        private WebResource addParams() {
            return this.resource.queryParam("depth", this.depth.toString());
        }
    }
}

