/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteSpaceService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;

public class RemoteSpaceServiceImpl
extends AbstractRemoteService<SpaceService>
implements RemoteSpaceService {
    public static final String SPACE_RESOURCE_PATH = "space";
    public static final String PRIVATE_SPACE_SUBPATH = "_private";

    public RemoteSpaceServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Space> create(Space newSpace, boolean isPrivate) throws ServiceException {
        WebResource resource = this.newSpacesRestResource();
        if (isPrivate) {
            resource = resource.path(PRIVATE_SPACE_SUBPATH);
        }
        return this.postFuture(resource, Space.class, newSpace);
    }

    @Override
    public SpaceService.Validator validator() {
        throw new NotImplementedServiceException("SpaceService.validator() not yet supported");
    }

    @Override
    public Promise<Option<Space>> getSpace(String spaceKey, Expansion ... expansions) {
        WebResource resource = this.newSpacesRestResource(spaceKey);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureOption(resource, Space.class);
    }

    @Override
    public RemoteSpaceService.RemoteSpaceContentFinder findContent(Space space, Expansion ... expansion) {
        return new RemoteSpaceContentFinderImpl(this, space, expansion);
    }

    private WebResource newSpacesRestResource() {
        return this.newRestWebResource().path(SPACE_RESOURCE_PATH);
    }

    private WebResource newSpacesRestResource(Space space) {
        return this.newSpacesRestResource(space.getKey());
    }

    private WebResource newSpacesRestResource(String spaceKey) {
        return this.newSpacesRestResource().path(spaceKey);
    }

    public class RemoteSpaceContentFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceContentFinder>
    implements RemoteSpaceService.RemoteSpaceContentFinder {
        WebResource resource;
        private Depth depth;

        public RemoteSpaceContentFinderImpl(AbstractRemoteService other, Space space, Expansion[] expansion) {
            super(other);
            this.depth = Depth.ALL;
            this.resource = RemoteSpaceServiceImpl.this.newSpacesRestResource(space).path("content");
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        private WebResource addParams() {
            return this.resource.queryParam("depth", this.depth.toString());
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource.path(type.getType().toLowerCase()), request);
            this.resource = this.addParams();
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteSpaceService.RemoteSpaceContentFinder withDepth(Depth depth) {
            this.depth = depth;
            return this;
        }
    }
}

