/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.AttachmentUpload;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.filter.AttachmentFilter;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteAttachmentService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.RemoteContentServiceImpl;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAttachmentServiceImpl
extends AbstractRemoteService<AttachmentService>
implements RemoteAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(RemoteAttachmentServiceImpl.class);
    private final RemoteContentService remoteContentService;

    public RemoteAttachmentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
        this.remoteContentService = new RemoteContentServiceImpl(provider, executor);
    }

    @Override
    public Promise<PageResponse<Content>> addAttachments(ContentId contentId, Collection<AttachmentUpload> uploads) throws ServiceException {
        WebResource resource = this.getAttachmentWebResource(contentId);
        FormDataMultiPart multiPart = this.makeMultiPart(uploads);
        return this.postFutureToPageResponse(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    private WebResource getAttachmentWebResource(ContentId contentId) {
        return this.newRestWebResource().path("content").path(contentId.serialise()).path("child").path("attachment");
    }

    @Override
    public Promise<Boolean> canCreateAttachments(ContentId contentId) {
        throw new UnsupportedOperationException("Cannot call canCreateAttachments on remote client yet");
    }

    @Override
    public Promise<PageResponse<Content>> getAttachments(ContentId contentId, PageRequest pageRequest, AttachmentFilter filter, Expansion ... expansions) throws ServiceException {
        String filterMediaType;
        WebResource resource = this.getAttachmentWebResource(contentId);
        resource = this.addExpansions(resource, expansions);
        resource = this.addPageRequest(resource, pageRequest);
        String filterFilename = filter.getFilename();
        if (filterFilename != null) {
            resource = resource.queryParam("filename", filterFilename);
        }
        if ((filterMediaType = filter.getMediaType()) != null) {
            resource = resource.queryParam("mediaType", filterMediaType);
        }
        return this.getFuturePageResponseList(resource, Content.class);
    }

    @Override
    public Promise<Option<Content>> findByContainerAndFilename(ContentId containerId, String filename, Expansion ... expansions) throws ServiceException {
        AttachmentFilter filter = AttachmentFilter.builder().filename(filename).build();
        Promise<PageResponse<Content>> pageResponsePromise = this.getAttachments(containerId, (PageRequest)new SimplePageRequest(0, 1), filter, expansions);
        return pageResponsePromise.map((Function)new Function<PageResponse<Content>, Option<Content>>(){

            public Option<Content> apply(PageResponse<Content> input) {
                if (input.size() == 0) {
                    return Option.none();
                }
                if (input.size() > 1) {
                    throw new IllegalStateException("findByContainerAndFilename should only locate a single attachment");
                }
                return Option.some(input.getResults().get(0));
            }
        });
    }

    @Override
    public Promise<Content> update(Content attachment) throws ServiceException {
        ContentId containerId = ((Content)attachment.getContainer()).getId();
        WebResource resource = this.getAttachmentWebResource(containerId).path(attachment.getId().serialise());
        return this.putFuture(resource, Content.class, attachment);
    }

    @Override
    public Promise<Content> updateData(final ContentId attachmentId, final AttachmentUpload upload) throws ServiceException {
        Promise<Option<Content>> byId = this.remoteContentService.find(ExpansionsParser.parseSingle((String)"container")).withId(attachmentId).fetchOne();
        return byId.flatMap((Function)new Function<Option<Content>, Promise<Content>>(){

            public Promise<Content> apply(Option<Content> oldAttachmentOption) {
                Content container = (Content)((Content)oldAttachmentOption.get()).getContainer();
                WebResource resource = RemoteAttachmentServiceImpl.this.getAttachmentWebResource(container.getId()).path(attachmentId.serialise()).path("data");
                FormDataMultiPart multiPart = RemoteAttachmentServiceImpl.this.makeMultiPart(Lists.newArrayList((Object[])new AttachmentUpload[]{upload}));
                Promise<Content> postFuture = RemoteAttachmentServiceImpl.this.postFuture(resource, Content.class, multiPart, MediaType.MULTIPART_FORM_DATA_TYPE);
                return Promises.forFuture(postFuture);
            }
        });
    }

    @Override
    public Promise<Void> delete(Content attachmentContent) throws ServiceException {
        return this.remoteContentService.delete(attachmentContent);
    }

    private FormDataMultiPart makeMultiPart(Collection<AttachmentUpload> uploads) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        for (AttachmentUpload upload : uploads) {
            multiPart.bodyPart(this.makeBodyPart(upload));
            String comment = upload.getComment();
            if (comment == null) {
                comment = "";
            }
            multiPart.field("comment", comment);
            multiPart.field("minorEdit", Boolean.toString(upload.isMinorEdit()));
        }
        return multiPart;
    }

    private BodyPart makeBodyPart(AttachmentUpload upload) {
        MediaType mediaType;
        if (upload.getName().contains("\"")) {
            throw new IllegalArgumentException("Double-quotes in filenames are not supported in the REST client");
        }
        String mediaTypeStr = upload.getMediaType();
        try {
            mediaType = MediaType.valueOf((String)mediaTypeStr);
        }
        catch (IllegalArgumentException e) {
            log.warn("Using 'text/plain' because type supplied is not a known media-type: " + mediaTypeStr);
            mediaType = MediaType.TEXT_PLAIN_TYPE;
        }
        return new FileDataBodyPart("file", upload.getFile(), mediaType);
    }
}

