/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteSpaceService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import java.util.concurrent.Future;

public class RemoteSpaceServiceImpl
extends AbstractRemoteService<SpaceService>
implements RemoteSpaceService {
    public RemoteSpaceServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Future<Option<Space>> getSpace(String spaceKey, Expansion ... expansions) {
        WebResource resource = this.newRestWebResource().path("space").path(spaceKey);
        resource = this.addExpansions(resource, expansions);
        return this.getFutureOption(resource, Space.class);
    }

    @Override
    public Future<PageResponse<Content>> getContent(Space space, PageRequest pageRequest, Expansion ... expansions) {
        WebResource resource = this.newRestWebResource().path("space").path(space.getKey()).path("content");
        resource = this.addExpansions(resource, expansions);
        return this.getFuturePageResponseList(resource, Content.class);
    }

    @Override
    public RemoteSpaceService.RemoteSpaceContentFinder findContent(Space space, Expansion ... expansion) {
        return new RemoteSpaceContentFinderImpl(this, space, expansion);
    }

    public static class RemoteSpaceContentFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceContentFinder>
    implements RemoteSpaceService.RemoteSpaceContentFinder {
        WebResource resource;
        private SpaceService.SpaceContentFinder.SpaceContentDepth depth = SpaceService.SpaceContentFinder.SpaceContentDepth.ALL;

        public RemoteSpaceContentFinderImpl(AbstractRemoteService other, Space space, Expansion[] expansion) {
            super(other);
            this.resource = this.newRestWebResource().path("space").path(space.getKey()).path("content");
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        private WebResource addParams() {
            return this.resource.queryParam("depth", this.depth.toString());
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource.path(type.getType().toLowerCase()), request);
            this.resource = this.addParams();
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteSpaceService.RemoteSpaceContentFinder withDepth(SpaceService.SpaceContentFinder.SpaceContentDepth depth) {
            this.depth = depth;
            return this;
        }
    }
}

