/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerCommand;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ZeroDowntime
extends DeployerCommand {
    List<String> environmentNames;
    String environmentId;
    String templateName;

    @Override
    public boolean perform() throws Exception {
        this.environmentNames = this.generateEnvironmentNames();
        try {
            this.environmentId = this.lookupEnvironmentIds(this.environmentNames);
        }
        catch (InvalidEnvironmentsSizeException exc) {
            this.log("Unable to find any suitable environment. Aborting.", new Object[0]);
            return true;
        }
        this.templateName = this.createConfigurationTemplate(this.environmentId);
        String clonedEnvironmentId = this.createEnvironment(this.getVersionLabel(), this.templateName, this.environmentNames);
        this.setEnvironmentId(clonedEnvironmentId);
        this.log("From now on, we'll use '%s' as the environmentId, but once finished, we'll swap and replace with '%s'", this.getEnvironmentId(), this.environmentId);
        return false;
    }

    private List<String> generateEnvironmentNames() {
        ArrayList newEnvironmentNames = Lists.newArrayList((Object[])new String[]{this.getEnvironmentName()});
        boolean lengthyP = this.getEnvironmentName().length() > 21;
        String newEnvironmentName = this.getEnvironmentName();
        if (lengthyP) {
            newEnvironmentName = this.getEnvironmentName().substring(0, this.getEnvironmentName().length() - 2);
        }
        newEnvironmentNames.add(newEnvironmentName + "-2");
        return newEnvironmentNames;
    }

    private String createEnvironment(String versionLabel, String templateName, List<String> environmentNames) {
        this.log("Creating environment based on application %s/%s from version %s and configuration template %s", this.getApplicationName(), this.getEnvironmentName(), versionLabel, templateName);
        String newEnvironmentName = environmentNames.get(0);
        for (String environmentName : environmentNames) {
            try {
                this.lookupEnvironmentIds(Collections.singletonList(environmentName));
            }
            catch (InvalidEnvironmentsSizeException e) {
                newEnvironmentName = environmentName;
                break;
            }
        }
        CreateEnvironmentRequest request = new CreateEnvironmentRequest().withEnvironmentName(newEnvironmentName).withVersionLabel(versionLabel).withApplicationName(this.getApplicationName()).withTemplateName(templateName);
        return this.getAwseb().createEnvironment(request).getEnvironmentId();
    }

    private void terminateEnvironment(String environmentId) {
        DescribeEnvironmentsResult result = this.getAwseb().describeEnvironments(new DescribeEnvironmentsRequest().withEnvironmentIds(new String[]{environmentId}).withIncludeDeleted(Boolean.valueOf(false)));
        if (result.getEnvironments().isEmpty()) {
            this.log("Environment environmentId '%s' was already finished.", new Object[0]);
            return;
        }
        this.log("Terminating environment %s", environmentId);
        TerminateEnvironmentRequest request = new TerminateEnvironmentRequest().withEnvironmentId(environmentId);
        this.getAwseb().terminateEnvironment(request);
    }

    private void swapEnvironmentCnames(String environmentId, String clonedEnvironmentId) throws InterruptedException {
        this.log("Swapping CNAMEs from environment %s to %s", environmentId, clonedEnvironmentId);
        SwapEnvironmentCNAMEsRequest request = new SwapEnvironmentCNAMEsRequest().withSourceEnvironmentId(environmentId).withDestinationEnvironmentId(clonedEnvironmentId);
        this.getAwseb().swapEnvironmentCNAMEs(request);
        Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
    }

    private String createConfigurationTemplate(String environmentId) {
        this.log("Creating configuration template from application %s with label %s", this.getApplicationName(), this.getVersionLabel());
        CreateConfigurationTemplateRequest request = new CreateConfigurationTemplateRequest().withApplicationName(this.getApplicationName()).withEnvironmentId(environmentId).withTemplateName("tmp-" + this.getVersionLabel());
        return this.getAwseb().createConfigurationTemplate(request).getTemplateName();
    }

    private String lookupEnvironmentIds(List<String> environmentNames) throws InvalidEnvironmentsSizeException {
        DescribeEnvironmentsResult environments = this.getAwseb().describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(this.getApplicationName()).withIncludeDeleted(Boolean.valueOf(false)));
        for (EnvironmentDescription env : environments.getEnvironments()) {
            if (!environmentNames.contains(env.getEnvironmentName())) continue;
            return env.getEnvironmentId();
        }
        throw new InvalidEnvironmentsSizeException(this.getApplicationName(), environmentNames.get(0), environments.getEnvironments().size());
    }

    @Override
    public boolean release() throws Exception {
        if (this.isSuccessfulP()) {
            this.swapEnvironmentCnames(this.environmentId, this.getEnvironmentId());
            this.deleteTemplateName(this.templateName);
            this.terminateEnvironment(this.environmentId);
        } else if (StringUtils.isNotBlank((String)this.getEnvironmentId())) {
            this.log("Rolling back on candidate environmentId '%s'", this.getEnvironmentId());
            this.terminateEnvironment(this.getEnvironmentId());
        }
        return false;
    }

    private void deleteTemplateName(String templateName) {
        this.log("Excluding template name '%s'", templateName);
        this.getAwseb().deleteConfigurationTemplate(new DeleteConfigurationTemplateRequest(this.getApplicationName(), templateName));
    }

    public static class InvalidEnvironmentsSizeException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String applicationName;
        private final String environmentName;
        private final int environmentCount;

        public InvalidEnvironmentsSizeException(String applicationName, String environmentName, int environmentCount) {
            this.applicationName = applicationName;
            this.environmentName = environmentName;
            this.environmentCount = environmentCount;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getEnvironmentName() {
            return this.environmentName;
        }

        public int getEnvironmentCount() {
            return this.environmentCount;
        }
    }
}

