/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSClientFactory;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Constants;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.WaitFor;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import hudson.FilePath;
import hudson.remoting.Pipe;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

public class DeployerCommand
implements Constants {
    protected DeployerContext c;

    public void setDeployerContext(DeployerContext c) {
        this.c = c;
    }

    public boolean perform() throws Exception {
        return false;
    }

    public boolean release() throws Exception {
        return false;
    }

    protected void log(String message, Object ... args) {
        this.getLogger().printf(message, args);
        this.getLogger().println();
    }

    public DeployerContext getC() {
        return this.c;
    }

    public void setC(DeployerContext c) {
        this.c = c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployerCommand)) {
            return false;
        }
        DeployerCommand other = (DeployerCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeployerContext this$c = this.getC();
        DeployerContext other$c = other.getC();
        return !(this$c == null ? other$c != null : !((Object)this$c).equals(other$c));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeployerCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployerContext $c = this.getC();
        result = result * 59 + ($c == null ? 43 : ((Object)$c).hashCode());
        return result;
    }

    public String toString() {
        return "DeployerCommand(c=" + this.getC() + ")";
    }

    public AWSEBDeploymentConfig getDeployerConfig() {
        return this.getC().getDeployerConfig();
    }

    public FilePath getRootFileObject() {
        return this.getC().getRootFileObject();
    }

    public Pipe getLoggerOut() {
        return this.getC().getLoggerOut();
    }

    public AmazonS3 getS3() {
        return this.getC().getS3();
    }

    public AWSElasticBeanstalk getAwseb() {
        return this.getC().getAwseb();
    }

    public PrintStream getLogger() {
        return this.getC().getLogger();
    }

    public String getKeyPrefix() {
        return this.getC().getKeyPrefix();
    }

    public String getBucketName() {
        return this.getC().getBucketName();
    }

    public String getApplicationName() {
        return this.getC().getApplicationName();
    }

    public String getVersionLabel() {
        return this.getC().getVersionLabel();
    }

    public String getObjectKey() {
        return this.getC().getObjectKey();
    }

    public String getS3ObjectPath() {
        return this.getC().getS3ObjectPath();
    }

    public String getEnvironmentName() {
        return this.getC().getEnvironmentName();
    }

    public String getEnvironmentId() {
        return this.getC().getEnvironmentId();
    }

    public boolean isSuccessfulP() {
        return this.getC().isSuccessfulP();
    }

    public void setS3(AmazonS3 s3) {
        this.getC().setS3(s3);
    }

    public void setAwseb(AWSElasticBeanstalk awseb) {
        this.getC().setAwseb(awseb);
    }

    public void setLogger(PrintStream logger) {
        this.getC().setLogger(logger);
    }

    public void setKeyPrefix(String keyPrefix) {
        this.getC().setKeyPrefix(keyPrefix);
    }

    public void setBucketName(String bucketName) {
        this.getC().setBucketName(bucketName);
    }

    public void setApplicationName(String applicationName) {
        this.getC().setApplicationName(applicationName);
    }

    public void setVersionLabel(String versionLabel) {
        this.getC().setVersionLabel(versionLabel);
    }

    public void setObjectKey(String objectKey) {
        this.getC().setObjectKey(objectKey);
    }

    public void setS3ObjectPath(String s3ObjectPath) {
        this.getC().setS3ObjectPath(s3ObjectPath);
    }

    public void setEnvironmentName(String environmentName) {
        this.getC().setEnvironmentName(environmentName);
    }

    public void setEnvironmentId(String environmentId) {
        this.getC().setEnvironmentId(environmentId);
    }

    public void setSuccessfulP(boolean successfulP) {
        this.getC().setSuccessfulP(successfulP);
    }

    public static class AbortPendingUpdates
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(this.getApplicationName()).withEnvironmentIds(new String[]{this.getEnvironmentId()}).withIncludeDeleted(Boolean.valueOf(false));
            DescribeEnvironmentsResult result = this.getAwseb().describeEnvironments(req);
            if (1 != result.getEnvironments().size()) {
                this.log("Environment w/ environmentId '%s' not found. Aborting.", this.getEnvironmentId());
                return true;
            }
            String resultingStatus = ((EnvironmentDescription)result.getEnvironments().get(0)).getStatus();
            boolean abortableP = ((EnvironmentDescription)result.getEnvironments().get(0)).getAbortableOperationInProgress();
            if (!"Ready".equals(resultingStatus)) {
                if (abortableP) {
                    this.log("AWS Abortable Environment Update Found. Calling abort on AWSEB Service", new Object[0]);
                    this.getAwseb().abortEnvironmentUpdate(new AbortEnvironmentUpdateRequest().withEnvironmentId(this.getEnvironmentId()));
                    this.log("Environment Update Aborted. Proceeding.", new Object[0]);
                }
                WaitForEnvironment waitForStatus = new WaitForEnvironment(WaitFor.Status);
                waitForStatus.setDeployerContext(this.c);
                return waitForStatus.perform();
            }
            this.log("No pending Environment Updates. Proceeding.", new Object[0]);
            return false;
        }
    }

    public static class MarkAsSuccessful
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.log("Deployment marked as 'successful'. Starting post-deployment cleanup.", new Object[0]);
            this.setSuccessfulP(true);
            return false;
        }
    }

    public static class WaitForEnvironment
    extends DeployerCommand {
        final WaitFor waitFor;

        public WaitForEnvironment(WaitFor waitFor) {
            this.waitFor = waitFor;
        }

        @Override
        public boolean perform() throws Exception {
            for (int nAttempt = 1; nAttempt <= 30; ++nAttempt) {
                this.log("Checking health/status of environmentId %s attempt %d/%s", this.getEnvironmentId(), nAttempt, 30);
                List environments = this.getAwseb().describeEnvironments(new DescribeEnvironmentsRequest().withEnvironmentIds(Collections.singletonList(this.getEnvironmentId())).withIncludeDeleted(Boolean.valueOf(false))).getEnvironments();
                if (environments.size() != 1) {
                    this.log("Environment not found. Aborting", new Object[0]);
                    return true;
                }
                EnvironmentDescription environmentDescription = (EnvironmentDescription)environments.get(0);
                boolean bHealthyP = "Green".equals(environmentDescription.getHealth());
                boolean bReadyP = "Ready".equals(environmentDescription.getStatus());
                if (WaitFor.Health == this.waitFor) {
                    if (bHealthyP) {
                        this.log("Environment Health is 'Green'. Moving on.", new Object[0]);
                        return false;
                    }
                } else if (WaitFor.Status == this.waitFor) {
                    if (bReadyP) {
                        this.log("Environment Status is 'Ready'. Moving on.", new Object[0]);
                        return false;
                    }
                } else if (WaitFor.Both == this.waitFor && bReadyP && bHealthyP) {
                    this.log("Environment Status is 'Ready' and Health is 'Green'. Moving on.", new Object[0]);
                    return false;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(90L));
            }
            this.log("Environment Update timed-out. Aborting.", new Object[0]);
            return true;
        }
    }

    public static class UpdateApplicationVersion
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            UpdateEnvironmentRequest req = new UpdateEnvironmentRequest().withEnvironmentId(this.getEnvironmentId()).withVersionLabel(this.getVersionLabel());
            this.log("Updating environmentId '%s' with Version Label set to '%s'", this.getEnvironmentId(), this.getVersionLabel());
            this.getAwseb().updateEnvironment(req);
            return false;
        }
    }

    public static class LookupEnvironmentId
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(this.getApplicationName()).withEnvironmentNames(new String[]{this.getEnvironmentName()}).withIncludeDeleted(Boolean.valueOf(false));
            DescribeEnvironmentsResult result = this.getAwseb().describeEnvironments(req);
            if (1 != result.getEnvironments().size()) {
                this.log("Unable to lookup environmentId. Skipping Update.", new Object[0]);
                return true;
            }
            String environmentId = ((EnvironmentDescription)result.getEnvironments().get(0)).getEnvironmentId();
            this.log("Using environmentId '%s'", environmentId);
            this.setEnvironmentId(environmentId);
            return false;
        }
    }

    public static class CreateApplicationVersion
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.log("Creating application version %s for application %s for path %s", this.getVersionLabel(), this.getApplicationName(), this.getS3ObjectPath());
            CreateApplicationVersionRequest cavRequest = new CreateApplicationVersionRequest().withApplicationName(this.getApplicationName()).withAutoCreateApplication(Boolean.valueOf(true)).withSourceBundle(new S3Location(this.getBucketName(), this.getObjectKey())).withVersionLabel(this.getVersionLabel());
            CreateApplicationVersionResult result = this.getAwseb().createApplicationVersion(cavRequest);
            this.log("Created version: %s", result.getApplicationVersion().getVersionLabel());
            return false;
        }
    }

    public static class InitAWS
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            AWSClientFactory factory = null != this.getDeployerConfig().getCredentials() ? AWSClientFactory.getClientFactory(this.getDeployerConfig().getCredentials(), this.getDeployerConfig().getAwsRegion()) : AWSClientFactory.getClientFactory("", this.getDeployerConfig().getAwsRegion());
            this.setS3((AmazonS3)factory.getService(AmazonS3Client.class));
            this.setAwseb((AWSElasticBeanstalk)factory.getService(AWSElasticBeanstalkClient.class));
            return false;
        }
    }

    public static class ValidateParameters
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.setKeyPrefix(this.getDeployerConfig().getKeyPrefix());
            this.setBucketName(this.getDeployerConfig().getBucketName());
            this.setApplicationName(this.getDeployerConfig().getApplicationName());
            this.setVersionLabel(this.getDeployerConfig().getVersionLabelFormat());
            this.setEnvironmentName(this.getDeployerConfig().getEnvironmentName());
            Validate.notEmpty((String)this.getEnvironmentName(), (String)"Empty/blank environmentName parameter");
            Validate.notEmpty((String)this.getApplicationName(), (String)"Empty/blank applicationName parameter");
            Validate.notEmpty((String)this.getVersionLabel(), (String)"Empty/blank versionLabel parameter");
            Validate.isTrue((boolean)this.getRootFileObject().exists(), (String)"Root Object doesn't exist");
            return false;
        }
    }

    public static class InitLogger
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            if (null == this.getLogger() && null != this.getLoggerOut()) {
                this.setLogger(new PrintStream(this.getLoggerOut().getOut(), true));
            }
            this.log("AWSEB Deployment Plugin Version %s", Utils.getVersion());
            return false;
        }
    }
}

