/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSClientFactory;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentBuilder;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.SlaveDeployerCallable;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerChain;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.LocalChannel;
import hudson.remoting.Pipe;
import hudson.remoting.VirtualChannel;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class DeployerRunner {
    final AbstractBuild<?, ?> build;
    final Launcher launcher;
    final BuildListener listener;
    final AWSEBDeploymentBuilder deploymentBuilder;

    public DeployerRunner(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, AWSEBDeploymentBuilder deploymentBuilder) {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
        this.deploymentBuilder = deploymentBuilder;
    }

    public boolean perform() throws Exception {
        int nRead;
        VirtualChannel channel;
        EnvVars environment = this.build.getEnvironment((TaskListener)this.listener);
        AWSEBDeploymentConfig deploymentConfig = this.deploymentBuilder.asConfig().replacedCopy(new Utils.Replacer(environment));
        PrintStream logger = this.listener.getLogger();
        FilePath rootFileObject = new FilePath(this.build.getWorkspace(), deploymentConfig.getRootObject());
        Pipe outputPipe = Pipe.createRemoteToLocal();
        DeployerContext deployerContext = new DeployerContext(deploymentConfig, rootFileObject, outputPipe);
        if (!StringUtils.isBlank((String)deploymentConfig.getCredentialId())) {
            deploymentConfig.setCredentials(AWSClientFactory.lookupNamedCredential(deploymentConfig.getCredentialId()));
        }
        if (LocalChannel.class.isAssignableFrom((channel = this.launcher.getChannel()).getClass())) {
            deployerContext.setLogger(this.listener.getLogger());
            DeployerChain deployerChain = new DeployerChain(deployerContext);
            return deployerChain.perform();
        }
        Future booleanFuture = channel.callAsync((Callable)new SlaveDeployerCallable(deployerContext));
        byte[] buf = new byte[8192];
        do {
            if (outputPipe.getIn().available() <= 0) {
                Thread.sleep(200L);
                continue;
            }
            nRead = outputPipe.getIn().read(buf, 0, Math.min(buf.length, outputPipe.getIn().available()));
            if (nRead <= 0) {
                Thread.sleep(200L);
                continue;
            }
            logger.write(buf, 0, nRead);
        } while (!booleanFuture.isDone());
        Thread.sleep(1000L);
        if (outputPipe.getIn().available() > 0) {
            nRead = outputPipe.getIn().read(buf, 0, outputPipe.getIn().available());
            logger.write(buf, 0, nRead);
        }
        return (Boolean)booleanFuture.get();
    }
}

