/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.jenkins.plugins.packer;

import biz.neustar.jenkins.plugins.packer.PackerFileEntry;
import biz.neustar.jenkins.plugins.packer.PackerInstallation;
import biz.neustar.jenkins.plugins.packer.TemplateMode;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PackerPublisher
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(PackerPublisher.class.getName());
    public static final String TEMPLATE_MODE = "templateMode";
    private final String name;
    private String jsonTemplate = "";
    private String jsonTemplateText;
    private String packerHome = "";
    private String params = "";
    private final boolean useDebug;
    private final String changeDir;
    private String templateMode = TemplateMode.GLOBAL.toMode();
    private List<PackerFileEntry> fileEntries = Collections.emptyList();

    @DataBoundConstructor
    public PackerPublisher(String name, String jsonTemplate, String jsonTemplateText, String packerHome, String params, List<PackerFileEntry> fileEntries, boolean useDebug, String changeDir) {
        this.name = name;
        this.jsonTemplate = jsonTemplate;
        this.jsonTemplateText = jsonTemplateText;
        this.packerHome = packerHome;
        this.params = params;
        this.fileEntries = fileEntries;
        this.useDebug = useDebug;
        this.changeDir = changeDir;
    }

    public String getName() {
        return this.getInstallation().getName();
    }

    public String getPackerHome() {
        return this.packerHome;
    }

    public void setPackerHome(String packerHome) {
        this.packerHome = packerHome;
    }

    public List<PackerFileEntry> getFileEntries() {
        if (this.fileEntries == null) {
            return Collections.emptyList();
        }
        return this.fileEntries;
    }

    public void setFileEntries(List<PackerFileEntry> fileEntries) {
        this.fileEntries = fileEntries;
    }

    public String getJsonTemplate() {
        return this.jsonTemplate;
    }

    public void setJsonTemplate(String jsonTemplate) {
        this.jsonTemplate = jsonTemplate;
    }

    public String getJsonTemplateText() {
        return this.jsonTemplateText;
    }

    public void setJsonTemplateText(String jsonTemplateText) {
        this.jsonTemplateText = jsonTemplateText;
    }

    public String getGlobalTemplate() {
        PackerInstallation installation = this.getInstallation();
        if (installation.isTextTemplate()) {
            return installation.getJsonTemplateText();
        }
        return "Using File: " + installation.getJsonTemplate();
    }

    public static String createJsonTemplateTextTempFile(FilePath workspacePath, String contents) throws AbortException {
        try {
            LOGGER.info("jsonTemplateText: " + contents);
            if (Util.fixEmpty((String)contents) != null) {
                FilePath jsonFile = workspacePath.createTextTempFile("packer", ".json", contents, false);
                LOGGER.info("Using temp file: " + jsonFile.getRemote());
                return jsonFile.getRemote();
            }
        }
        catch (IOException ioe) {
            LOGGER.warning(PackerPublisher.convertException(ioe));
        }
        catch (InterruptedException inte) {
            LOGGER.warning(PackerPublisher.convertException(inte));
        }
        throw new AbortException("Template Generation / Loading Failed");
    }

    public String createJsonTemplateTextTempFile(FilePath workspacePath) throws AbortException {
        return PackerPublisher.createJsonTemplateTextTempFile(workspacePath, this.jsonTemplateText);
    }

    public String getTemplateMode() {
        return this.templateMode;
    }

    public void setTemplateMode(String templateMode) {
        this.templateMode = templateMode;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public boolean getUseDebug() {
        return this.useDebug;
    }

    public String getChangeDir() {
        return this.changeDir;
    }

    public boolean isFileTemplate() {
        return TemplateMode.FILE.isMode(this.templateMode);
    }

    public boolean isTextTemplate() {
        return TemplateMode.TEXT.isMode(this.templateMode);
    }

    public boolean isGlobalTemplate() {
        return TemplateMode.GLOBAL.isMode(this.templateMode);
    }

    public boolean isGlobalTemplateChecked() {
        return this.isGlobalTemplate() || !this.isFileTemplate() && !this.isTextTemplate();
    }

    public PackerInstallation getInstallation() {
        for (PackerInstallation install : this.getDescriptor().getInstallations()) {
            if (this.name == null || !install.getName().equals(this.name)) continue;
            return install;
        }
        return null;
    }

    public String getRemotePackerExec(AbstractBuild build, Launcher launcher, TaskListener listener) throws AbortException {
        String home = this.getPackerHome();
        String remoteExec = null;
        if (Util.fixEmpty((String)home) == null) {
            PackerInstallation install = this.getInstallation();
            try {
                install = install.forNode(build.getBuiltOn(), listener).forEnvironment(build.getEnvironment(listener));
                remoteExec = install.getExecutable(launcher);
            }
            catch (Exception ex) {
                LOGGER.severe(PackerPublisher.convertException(ex));
                throw new AbortException("Tool Installation Failed for: " + this.getName());
            }
        } else {
            FilePath execPath = this.getRemotePath(build, home);
            if (!home.toLowerCase().endsWith("packer.exe")) {
                execPath = new FilePath(execPath, PackerPublisher.isFilePathUnix(execPath) ? "packer" : "packer.exe");
            }
            remoteExec = execPath.getRemote();
        }
        LOGGER.info("Using packer: " + remoteExec);
        return remoteExec;
    }

    public String getRemoteTemplate(AbstractBuild build, String remotePath) {
        FilePath templatePath = this.getRemotePath(build, remotePath);
        LOGGER.info("Using templatePath: " + templatePath);
        return templatePath.getRemote();
    }

    public FilePath getRemotePath(AbstractBuild build, String remotePath) {
        return new FilePath(build.getWorkspace(), remotePath);
    }

    public String createTempFileEntries(FilePath workspacePath) throws AbortException {
        StringBuilder variables = new StringBuilder();
        PackerInstallation install = this.getInstallation();
        HashMap<String, PackerFileEntry> fileEntries = new HashMap<String, PackerFileEntry>();
        if (install != null) {
            for (PackerFileEntry entry : install.getFileEntries()) {
                fileEntries.put(entry.getVarFileName(), entry);
            }
        }
        try {
            for (PackerFileEntry entry : this.getFileEntries()) {
                fileEntries.put(entry.getVarFileName(), entry);
            }
            for (PackerFileEntry entry : fileEntries.values()) {
                FilePath entryFile = workspacePath.createTextTempFile(entry.getVarFileName(), ".tmp", entry.getContents(), false);
                variables.append(String.format("-var \"%s=%s\" ", entry.getVarFileName(), entryFile.getRemote()));
            }
        }
        catch (IOException e) {
            LOGGER.severe(PackerPublisher.convertException(e));
            throw new AbortException("File Entry Generation Failed");
        }
        catch (InterruptedException e) {
            LOGGER.severe(PackerPublisher.convertException(e));
            throw new AbortException("File Entry Generation Failed");
        }
        return variables.toString();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        try {
            String addParam;
            args.add(this.getRemotePackerExec(build, launcher, (TaskListener)listener)).add("build");
            EnvVars env = build.getEnvironment((TaskListener)listener);
            PackerInstallation installation = this.getInstallation();
            for (String param : PackerPublisher.addParamsAsArgs(Util.fixNull((String)installation.getParams()))) {
                addParam = param.trim();
                if (addParam.length() <= 0) continue;
                args.add(Util.replaceMacro((String)addParam, (Map)env), true);
            }
            for (String param : PackerPublisher.addParamsAsArgs(this.getParams())) {
                addParam = param.trim();
                if (addParam.length() <= 0) continue;
                args.add(Util.replaceMacro((String)addParam, (Map)env));
            }
            for (String val : PackerPublisher.addParamsAsArgs(this.createTempFileEntries(build.getWorkspace()))) {
                args.add(val);
            }
            if (this.getUseDebug()) {
                args.add("-debug");
            }
            if (this.isGlobalTemplate()) {
                LOGGER.info("Using GlobalTemplate");
                if (installation.isFileTemplate()) {
                    args.add(this.getRemoteTemplate(build, Util.replaceMacro((String)installation.getJsonTemplate(), (Map)env)));
                } else {
                    args.add(PackerPublisher.createJsonTemplateTextTempFile(build.getWorkspace(), installation.getJsonTemplateText()));
                }
            } else if (this.isTextTemplate()) {
                LOGGER.info("Using TextTemplate");
                args.add(this.createJsonTemplateTextTempFile(build.getWorkspace()));
            } else if (this.isFileTemplate()) {
                LOGGER.info("Using FileTemplate");
                args.add(this.getRemoteTemplate(build, Util.replaceMacro((String)this.getJsonTemplate(), (Map)env)));
            } else {
                LOGGER.warning("Unknown Template");
                throw new AbortException("Unknown Template / Loading Failed");
            }
            try {
                LOGGER.info("launch: " + args.toString());
                if (launcher.launch().pwd(this.workingDir(build, env)).cmds(args).stdout((TaskListener)listener).join() == 0) {
                    listener.finished(Result.SUCCESS);
                    return true;
                }
            }
            catch (Exception ex) {
                LOGGER.severe(PackerPublisher.convertException(ex));
                listener.fatalError("Execution failed: " + args);
            }
        }
        catch (Exception e) {
            LOGGER.severe(PackerPublisher.convertException(e));
            listener.fatalError("Execution failed: " + args);
        }
        listener.finished(Result.FAILURE);
        return false;
    }

    protected FilePath workingDir(AbstractBuild build, EnvVars env) {
        if (Util.fixEmpty((String)this.getChangeDir()) != null) {
            return new FilePath(build.getWorkspace().getChannel(), Util.replaceMacro((String)this.getChangeDir(), (Map)env));
        }
        return build.getWorkspace();
    }

    protected static String convertException(Exception ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isFilePathUnix(FilePath path) {
        if (!path.isRemote()) {
            return File.pathSeparatorChar != ';';
        }
        String remote = path.getRemote();
        if (remote.length() > 3 && remote.charAt(1) == ':' && remote.charAt(2) == '\\') {
            return false;
        }
        return remote.indexOf("\\") == -1;
    }

    public static List<String> addParamsAsArgs(String params) {
        ArrayList<String> args = new ArrayList<String>();
        if (params == null || params.isEmpty()) {
            return args;
        }
        char[] chars = params.toCharArray();
        int captureIndex = -1;
        char quoteChar = '\u0000';
        boolean inQuote = false;
        boolean stripQuotes = false;
        for (int index = 0; index < chars.length; ++index) {
            char c = chars[index];
            if (inQuote && c == quoteChar) {
                inQuote = false;
                continue;
            }
            if (captureIndex > -1 && !inQuote && c == ' ') {
                int start = stripQuotes ? captureIndex + 1 : captureIndex;
                int stop = stripQuotes ? index - 1 : index;
                args.add(params.substring(start, stop));
                captureIndex = -1;
                stripQuotes = false;
                continue;
            }
            if (captureIndex != -1 || inQuote || c == ' ') continue;
            captureIndex = index;
            if (c != '\'' && c != '\"') continue;
            inQuote = true;
            quoteChar = c;
            stripQuotes = true;
        }
        if (captureIndex > -1) {
            int start = stripQuotes ? captureIndex + 1 : captureIndex;
            int stop = stripQuotes ? params.length() - 1 : params.length();
            args.add(params.substring(start, stop));
        }
        return args;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private volatile PackerInstallation[] installations = new PackerInstallation[0];

        public PackerPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PackerPublisher packer = (PackerPublisher)((Object)req.bindJSON(this.clazz, formData));
            if (formData.has(PackerPublisher.TEMPLATE_MODE)) {
                JSONObject opt = formData.getJSONObject(PackerPublisher.TEMPLATE_MODE);
                packer.setTemplateMode(opt.getString("value"));
                packer.setJsonTemplate(opt.optString("jsonTemplate"));
                packer.setJsonTemplateText(opt.optString("jsonTemplateText"));
            }
            return packer;
        }

        public PackerInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(PackerInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public boolean isGlobalTemplateChecked(PackerPublisher instance) {
            boolean result = true;
            if (instance != null) {
                result = instance.isGlobalTemplateChecked();
            }
            return result;
        }

        public String getGlobalTemplate(PackerPublisher instance) {
            String result = "Save and reload to see global template...";
            if (instance != null) {
                result = instance.getGlobalTemplate();
            }
            return result;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Packer";
        }
    }
}

