/*
 * Decompiled with CFR 0.152.
 */
package biz.neustar.jenkins.plugins.packer;

import biz.neustar.jenkins.plugins.packer.PackerFileEntry;
import biz.neustar.jenkins.plugins.packer.TemplateMode;
import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackerInstallation
extends ToolInstallation
implements EnvironmentSpecific<PackerInstallation>,
NodeSpecific<PackerInstallation>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PackerInstallation.class.getName());
    public static final String UNIX_PACKER_COMMAND = "packer";
    public static final String WINDOWS_PACKER_COMMAND = "packer.exe";
    private final String packerHome;
    private String params = "";
    private String jsonTemplate = "";
    private String jsonTemplateText = "";
    private final JSONObject templateModeJsonObj;
    private String templateMode = TemplateMode.TEXT.toMode();
    private List<PackerFileEntry> fileEntries = Collections.emptyList();

    @DataBoundConstructor
    public PackerInstallation(String name, String home, String params, JSONObject templateMode, List<PackerFileEntry> fileEntries, List<? extends ToolProperty<?>> properties) {
        super(name, PackerInstallation.launderHome((String)home), properties);
        this.packerHome = super.getHome();
        this.params = params;
        this.fileEntries = fileEntries;
        this.templateModeJsonObj = templateMode;
        this.jsonTemplate = this.templateModeJsonObj.optString("jsonTemplate", null);
        this.jsonTemplateText = this.templateModeJsonObj.optString("jsonTemplateText", null);
        if (!Strings.isNullOrEmpty((String)this.templateModeJsonObj.optString("value", null))) {
            this.templateMode = this.templateModeJsonObj.getString("value");
        }
    }

    private static String launderHome(String home) {
        if (home.endsWith("/") || home.endsWith("\\")) {
            return home.substring(0, home.length() - 1);
        }
        return home;
    }

    public String getHome() {
        if (this.packerHome != null) {
            return this.packerHome;
        }
        return super.getHome();
    }

    public List<PackerFileEntry> getFileEntries() {
        if (this.fileEntries == null) {
            return Collections.emptyList();
        }
        return this.fileEntries;
    }

    public String getParams() {
        return this.params;
    }

    public String getJsonTemplate() {
        return this.jsonTemplate;
    }

    public String getJsonTemplateText() {
        return this.jsonTemplateText;
    }

    public String getTemplateMode() {
        return this.templateMode;
    }

    public boolean isFileTemplate() {
        return TemplateMode.FILE.isMode(this.templateMode);
    }

    public boolean isTextTemplate() {
        return TemplateMode.TEXT.isMode(this.templateMode);
    }

    public PackerInstallation forEnvironment(EnvVars environment) {
        return new PackerInstallation(this.getName(), environment.expand(this.packerHome), this.params, this.templateModeJsonObj, this.fileEntries, this.getProperties().toList());
    }

    public PackerInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new PackerInstallation(this.getName(), this.translateFor(node, log), this.params, this.templateModeJsonObj, this.fileEntries, this.getProperties().toList());
    }

    public String getExecutable(Launcher launcher) throws InterruptedException, IOException {
        return (String)launcher.getChannel().call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected File getExeFile() {
        String execName = Functions.isWindows() ? "packer.exe" : "packer";
        String home = Util.replaceMacro((String)this.packerHome, (Map)EnvVars.masterEnvVars);
        return new File(home, execName);
    }
}

