/*
 * Decompiled with CFR 0.152.
 */
package alex.jenkins.plugins;

import alex.jenkins.plugins.AdditionalBaseDirPath;
import alex.jenkins.plugins.FileSystemListParameterGlobalConfiguration;
import alex.jenkins.plugins.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    static boolean isAllowedPath(String path, File jenkinsRootDir, FileSystemListParameterGlobalConfiguration testGC) {
        FileSystemListParameterGlobalConfiguration globalConfig = testGC == null ? FileSystemListParameterGlobalConfiguration.get() : testGC;
        List<AdditionalBaseDirPath> additionalBaseDirs = globalConfig.getAdditionalBaseDirs();
        try {
            Object userContentPath;
            Path pathToCheck = new File(path).toPath().toAbsolutePath();
            if (globalConfig.isEnabledUserContent() && jenkinsRootDir != null && pathToCheck.startsWith((String)(userContentPath = jenkinsRootDir.getCanonicalPath() + File.separator + "userContent" + File.separator))) {
                return true;
            }
            for (AdditionalBaseDirPath baseDir : additionalBaseDirs) {
                String baseDirCanonical = new File(baseDir.getAdditionalBaseDirPath()).getCanonicalPath() + File.separator;
                if (!pathToCheck.startsWith(baseDirCanonical)) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warning(String.format(Messages.FileSystemListParameterDefinition_PathCheckError(), path));
        }
        return false;
    }

    static List<String> createTimeSortedList(Map<String, Long> map) {
        ArrayList<String> list = new ArrayList<String>();
        Collection<Long> valuesC = map.values();
        ArrayList<Long> sortList = new ArrayList<Long>(valuesC);
        Collections.sort(sortList);
        for (Long value : sortList) {
            if (!map.containsValue(value)) continue;
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                list.add(entry.getKey());
            }
        }
        return list;
    }
}

