/*
 * Decompiled with CFR 0.152.
 */
package alex.jenkins.plugins;

import alex.jenkins.plugins.FileSystemListParameterGlobalConfiguration;
import alex.jenkins.plugins.FileSystemListParameterValue;
import alex.jenkins.plugins.Messages;
import alex.jenkins.plugins.Utils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public class FileSystemListParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 9032072543915872650L;
    private static final Logger LOGGER = Logger.getLogger(FileSystemListParameterDefinition.class.getName());
    public static final String MASTER = "master";
    static FileSystemListParameterGlobalConfiguration testGC = null;
    private String selectedNodeName;
    private String path;
    private String selectedType;
    private String formSelectType;
    private boolean sortByLastModified;
    private boolean sortReverseOrder;
    private FsObjectTypes selectedEnumType;
    private String regexIncludePattern;
    private String regexExcludePattern;
    private String value;
    private String defaultValue;
    private boolean includePathInValue;

    static void addTestGC(FileSystemListParameterGlobalConfiguration testGC) {
        FileSystemListParameterDefinition.testGC = testGC;
    }

    @DataBoundConstructor
    public FileSystemListParameterDefinition(String name, String description, String selectedNodeName, String path, String defaultValue, String selectedType, String formSelectType, String regexIncludePattern, String regexExcludePattern, boolean sortByLastModified, boolean sortReverseOrder, boolean includePathInValue) {
        super(name);
        this.selectedNodeName = selectedNodeName;
        this.path = Util.fixNull((String)path);
        this.defaultValue = defaultValue;
        this.selectedType = selectedType;
        this.formSelectType = formSelectType;
        this.selectedEnumType = FsObjectTypes.valueOf(selectedType);
        this.sortByLastModified = sortByLastModified;
        this.sortReverseOrder = sortReverseOrder;
        this.regexIncludePattern = regexIncludePattern;
        this.regexExcludePattern = regexExcludePattern;
        this.includePathInValue = includePathInValue;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        StringParameterValue parameterValue = new StringParameterValue(this.getName(), this.isIncludePathInValue() ? new File(this.path, String.valueOf(value)).getPath() : String.valueOf(value));
        return this.checkParameterValue(parameterValue);
    }

    private ParameterValue checkParameterValue(StringParameterValue parameterValue) {
        try {
            List<String> valuesPossible = this.getFsObjectsList();
            if (valuesPossible.contains(parameterValue.getValue())) {
                return parameterValue;
            }
            LOGGER.warning(String.format(Messages.FileSystemListParameterDefinition_InjectedObjectNotFoundAtPath(), parameterValue.getValue(), this.path));
            return null;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Problem checking value: " + e.getMessage());
        }
    }

    public ParameterValue createValue(StaplerRequest req) {
        return this.createValue(this.requireRequest2(req));
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        return this.createValue(this.requireRequest2(req), jo);
    }

    private StaplerRequest2 requireRequest2(StaplerRequest req) {
        if (req instanceof StaplerRequest2) {
            return (StaplerRequest2)req;
        }
        throw new IllegalStateException("StaplerRequest2 expected but got " + req.getClass());
    }

    public ParameterValue createValue(StaplerRequest2 request) {
        String[] parameterValues = request.getParameterValues(this.getName());
        if (parameterValues == null || parameterValues.length == 0) {
            return this.getDefaultParameterValue();
        }
        String value = parameterValues[0];
        StringParameterValue stringParameterValue = new StringParameterValue(this.getName(), this.isIncludePathInValue() ? new File(this.path, String.valueOf(value)).getPath() : String.valueOf(value));
        return this.checkParameterValue(stringParameterValue);
    }

    public ParameterValue createValue(StaplerRequest2 request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = this.isIncludePathInValue() ? new File(this.path, String.valueOf(value)).getPath() : String.valueOf(value);
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            strValue = StringUtils.join((Iterator)(this.isIncludePathInValue() ? jsonValues.stream().filter(e -> !StringUtils.isBlank((CharSequence)String.valueOf(e))).map(e -> new File(this.path, String.valueOf(e)).getPath()).iterator() : jsonValues.iterator()), (char)',');
        }
        return new FileSystemListParameterValue(this.getName(), strValue);
    }

    public ParameterValue getDefaultParameterValue() {
        String localDefaultValue = "";
        try {
            localDefaultValue = this.getEffectiveDefaultValue();
        }
        catch (Exception e) {
            LOGGER.warning(String.format(Messages.FileSystemListParameterDefinition_SymlinkDetectionError(), localDefaultValue));
        }
        if (!StringUtils.isBlank((CharSequence)localDefaultValue)) {
            return new FileSystemListParameterValue(this.getName(), this.isIncludePathInValue() ? new File(this.path, localDefaultValue).getPath() : localDefaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String getEffectiveDefaultValue() throws Exception {
        List<String> defaultList = this.getFsObjectsList();
        if (defaultList.contains(this.getDefaultValue())) {
            return this.getDefaultValue();
        }
        return defaultList.get(0);
    }

    public List<String> getFsObjectsList() throws Exception {
        Computer computer = null;
        VirtualChannel channel = null;
        Jenkins instance = Jenkins.getInstanceOrNull();
        File jenkinsRootdir = null;
        if (this.getSelectedNodeName() != null && !this.getSelectedNodeName().trim().isEmpty() && instance != null) {
            computer = instance.getComputer(this.getSelectedNodeName());
            if (computer != null) {
                channel = computer.getChannel();
            }
            jenkinsRootdir = instance.getRootDir();
        }
        ArrayList<String> notAllowedList = new ArrayList<String>();
        String msgNotAllowed = String.format(Messages.FileSystemListParameterDefinition_PathNotAllowed(), this.path).toString();
        LOGGER.warning(msgNotAllowed);
        notAllowedList.add(msgNotAllowed);
        if (instance == null) {
            notAllowedList.add("Jenkins instance is null! Sorry.");
            return notAllowedList;
        }
        if (!Utils.isAllowedPath(this.path, jenkinsRootdir, testGC)) {
            return notAllowedList;
        }
        FilePath rootPath = new FilePath(channel, this.path);
        return (List)rootPath.act((FilePath.FileCallable)new FilesLister(this.getSelectedEnumType(), this.getRegexIncludePattern(), this.getRegexExcludePattern(), this.getPath(), this.isSortByLastModified(), this.isSortReverseOrder()));
    }

    public List<String> getJellyFsObjectTypes() {
        ArrayList<String> list = new ArrayList<String>();
        String selected = this.getSelectedType();
        LOGGER.finest("# selectedType=" + selected);
        if (selected.equals("")) {
            for (FsObjectTypes type : FsObjectTypes.values()) {
                String string = type.toString();
                LOGGER.finest("# add " + string);
                list.add(string);
            }
        } else {
            LOGGER.finest("# add " + selected);
            list.add(selected);
            for (FsObjectTypes type : FsObjectTypes.values()) {
                String string = type.toString();
                if (selected.equals(string)) continue;
                LOGGER.finest("# add " + string);
                list.add(string);
            }
        }
        return list;
    }

    public List<String> getJellyFsFormSelectTypes() {
        ArrayList<String> list = new ArrayList<String>();
        String selected = this.getFormSelectType();
        LOGGER.finest("# formSelectType=" + selected);
        if (selected.equals("")) {
            for (FsSelectTypes type : FsSelectTypes.values()) {
                LOGGER.finest("# add " + type.toString());
                list.add(type.toString());
            }
        } else {
            LOGGER.finest("# add " + selected);
            list.add(selected);
            for (FsSelectTypes type : FsSelectTypes.values()) {
                if (selected.equals(type.toString())) continue;
                LOGGER.finest("# add " + type.toString());
                list.add(type.toString());
            }
        }
        return list;
    }

    public static List<String> getNodeNames() {
        ArrayList<String> list = new ArrayList<String>();
        List nodes = Jenkins.get().getNodes();
        list.add(MASTER);
        for (Node node : nodes) {
            String tmpNodeName = node.getNodeName();
            if (!StringUtils.isNotBlank((CharSequence)tmpNodeName)) continue;
            LOGGER.finest("# add " + tmpNodeName);
            list.add(tmpNodeName);
        }
        return list;
    }

    public String getPath() {
        return this.path;
    }

    public String getSelectedType() {
        return this.selectedType;
    }

    public boolean isSortByLastModified() {
        return this.sortByLastModified;
    }

    public boolean isSortReverseOrder() {
        return this.sortReverseOrder;
    }

    public FsObjectTypes getSelectedEnumType() {
        return this.selectedEnumType;
    }

    public String getFormSelectType() {
        return this.formSelectType;
    }

    public String getValue() {
        return this.value;
    }

    public String getRegexIncludePattern() {
        return this.regexIncludePattern;
    }

    public String getRegexExcludePattern() {
        return this.regexExcludePattern;
    }

    public String getSelectedNodeName() {
        return this.selectedNodeName;
    }

    public String setSelectedNodeName() {
        return this.selectedNodeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public boolean isIncludePathInValue() {
        return this.includePathInValue;
    }

    public static enum FsObjectTypes {
        ALL,
        DIRECTORY,
        FILE,
        SYMLINK;

    }

    static class FilesLister
    extends MasterToSlaveFileCallable<List<String>> {
        private static final long serialVersionUID = 1L;
        private FsObjectTypes selectedEnumType;
        private String regexIncludePattern;
        private String regexExcludePattern;
        private String path;
        private boolean isSortByLastModified;
        private boolean isSortReverseOrder;

        FilesLister(FsObjectTypes selectedEnumType, String regexIncludePattern, String regexExcludePattern, String path, boolean isSortByLastModified, boolean isSortReverseOrder) {
            this.selectedEnumType = selectedEnumType;
            this.regexIncludePattern = regexIncludePattern;
            this.regexExcludePattern = regexExcludePattern;
            this.path = path;
            this.isSortByLastModified = isSortByLastModified;
            this.isSortReverseOrder = isSortReverseOrder;
        }

        public List<String> invoke(File rootDir, VirtualChannel channel) {
            TreeMap<String, Long> map = new TreeMap<String, Long>();
            try {
                Path realPath = rootDir.toPath().toRealPath(new LinkOption[0]);
                Path absolutePath = rootDir.toPath().toAbsolutePath();
                if (!realPath.equals(absolutePath)) {
                    ArrayList<String> notAllowedList = new ArrayList<String>();
                    String msgNotAllowed = String.format(Messages.FileSystemListParameterDefinition_PathNotAllowed() + " Symlinks are not allowed to be used as list objects path.", this.path).toString();
                    LOGGER.warning(msgNotAllowed);
                    notAllowedList.add(msgNotAllowed);
                    return notAllowedList;
                }
                File[] listFiles = rootDir.listFiles();
                if (listFiles != null) {
                    switch (this.selectedEnumType) {
                        case SYMLINK: {
                            this.createSymlinkMap(listFiles, map);
                            break;
                        }
                        case DIRECTORY: {
                            this.createDirectoryMap(listFiles, map);
                            break;
                        }
                        case FILE: {
                            this.createFileMap(listFiles, map);
                            break;
                        }
                        default: {
                            this.createAllObjectsMap(listFiles, map);
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warning(String.format(Messages.FileSystemListParameterDefinition_SymlinkDetectionError(), "Failed to obtain"));
            }
            if (map.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                String msg = String.format(Messages.FileSystemListParameterDefinition_NoObjectsFoundAtPath(), new Object[]{this.selectedEnumType, this.regexIncludePattern, this.regexExcludePattern, this.path}).toString();
                LOGGER.warning(msg);
                list.add(msg);
                return list;
            }
            return this.sortList(map);
        }

        private boolean isPatternMatching(String name) {
            if (this.regexIncludePattern.equals("") && this.regexExcludePattern.equals("")) {
                return true;
            }
            if (!this.regexIncludePattern.equals("") && this.regexExcludePattern.equals("")) {
                return name.matches(this.regexIncludePattern);
            }
            if (this.regexIncludePattern.equals("") && !this.regexExcludePattern.equals("")) {
                return !name.matches(this.regexExcludePattern);
            }
            return name.matches(this.regexIncludePattern) && !name.matches(this.regexExcludePattern);
        }

        private void createSymlinkMap(File[] listFiles, Map<String, Long> target) throws IOException {
            for (File file : listFiles) {
                if (file.isHidden() || !Util.isSymlink((File)file) || !this.isPatternMatching(file.getName())) continue;
                target.put(file.getName(), file.lastModified());
                LOGGER.finest("add " + file);
            }
        }

        private void createDirectoryMap(File[] listFiles, Map<String, Long> target) throws IOException {
            for (File file : listFiles) {
                if (file.isHidden() || !file.isDirectory() || Util.isSymlink((File)file) || !this.isPatternMatching(file.getName())) continue;
                target.put(file.getName(), file.lastModified());
                LOGGER.finest("add " + file);
            }
        }

        private void createFileMap(File[] listFiles, Map<String, Long> target) throws IOException {
            for (File file : listFiles) {
                if (file.isHidden() || !file.isFile() || Util.isSymlink((File)file) || !this.isPatternMatching(file.getName())) continue;
                target.put(file.getName(), file.lastModified());
                LOGGER.finest("add " + file);
            }
        }

        private void createAllObjectsMap(File[] listFiles, Map<String, Long> target) {
            for (File file : listFiles) {
                if (file.isHidden() || !this.isPatternMatching(file.getName())) continue;
                target.put(file.getName(), file.lastModified());
                LOGGER.finest("add " + file);
            }
        }

        List<String> sortList(Map<String, Long> map) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isSortByLastModified) {
                list = Utils.createTimeSortedList(map);
            } else {
                list.addAll(map.keySet());
            }
            if (this.isSortReverseOrder) {
                Collections.reverse(list);
            }
            return list;
        }
    }

    public static enum FsSelectTypes {
        SINGLE_SELECT,
        MULTI_SELECT;

    }

    @Extension
    @Symbol(value={"fileSystemList"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.FileSystemListParameterDefinition_DisplayName();
        }

        public FormValidation doCheckName(@QueryParameter String name) throws IOException {
            if (StringUtils.isBlank((CharSequence)name)) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_NameCanNotBeEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPath(@QueryParameter String path, @QueryParameter String selectedNodeName) throws IOException, InterruptedException {
            FilePath filepath;
            if (StringUtils.isBlank((CharSequence)path)) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_PathCanNotBeEmpty());
            }
            if (Util.isSymlink((File)new File(path))) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_SymlinkPathNotAllowed(), (Object[])new Object[]{path});
            }
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (instance != null && !Utils.isAllowedPath(path, instance.getRootDir(), null)) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_PathNotAllowed(), (Object[])new Object[]{path});
            }
            Computer computer = null;
            VirtualChannel channel = null;
            if (selectedNodeName == null || selectedNodeName.equals(FileSystemListParameterDefinition.MASTER)) {
                File dir = new File(path);
                if (!dir.exists()) {
                    return FormValidation.error((String)Messages.FileSystemListParameterDefinition_PathDoesntExist(), (Object[])new Object[]{path});
                }
                String[] items = dir.list();
                if (items == null || items.length == 0) {
                    return FormValidation.warning((String)Messages.FileSystemListParameterDefinition_NoObjectsFound(), (Object[])new Object[]{path});
                }
                return FormValidation.ok();
            }
            if (!selectedNodeName.trim().isEmpty() && instance != null && (computer = instance.getComputer(selectedNodeName)) != null) {
                channel = computer.getChannel();
            }
            if (!(filepath = new FilePath(channel, path)).exists()) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_PathDoesntExist(), (Object[])new Object[]{path});
            }
            List list = filepath.list();
            if (list.isEmpty()) {
                return FormValidation.warning((String)Messages.FileSystemListParameterDefinition_NoObjectsFound(), (Object[])new Object[]{path});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRegexIncludePattern(@QueryParameter String regexIncludePattern) {
            return this.checkRegex(regexIncludePattern);
        }

        public FormValidation doCheckRegexExcludePattern(@QueryParameter String regexExcludePattern) {
            return this.checkRegex(regexExcludePattern);
        }

        private FormValidation checkRegex(String regex) {
            try {
                Pattern.compile(regex);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)Messages.FileSystemListParameterDefinition_RegExPatternNotValid(), (Object[])new Object[]{regex, pse.getDescription()});
            }
        }
    }
}

