/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import sp.sd.nexusartifactuploader.Artifact;
import sp.sd.nexusartifactuploader.Utils;

public class NexusArtifactUploader
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String nexusVersion;
    private final String protocol;
    private final String nexusUrl;
    private final String groupId;
    private final String version;
    private final String repository;
    private final List<Artifact> artifacts;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public NexusArtifactUploader(String nexusVersion, String protocol, String nexusUrl, String groupId, String version, String repository, String credentialsId, List<Artifact> artifacts) {
        this.nexusVersion = nexusVersion;
        this.protocol = protocol;
        this.nexusUrl = nexusUrl;
        this.groupId = groupId;
        this.version = version;
        this.repository = repository;
        this.credentialsId = credentialsId;
        this.artifacts = artifacts;
    }

    public String getNexusVersion() {
        return this.nexusVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRepository() {
        return this.repository;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials(Item project) {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = this.credentialsId == null ? null : (credentials = NexusArtifactUploader.lookupSystemCredentials(this.credentialsId, project));
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId, Item project) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(EnvVars environment, Item project) {
        String Username = "";
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Username = this.getCredentials(project).getUsername();
        }
        return Username;
    }

    public String getPassword(EnvVars environment, Item project) {
        String Password = "";
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials(project))).getPassword());
        }
        return Password;
    }

    public void perform(Run build, FilePath workspace, Launcher launcher, final TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment(listener);
        Job project = build.getParent();
        final String username = this.getUsername(envVars, (Item)project);
        final String password = this.getPassword(envVars, (Item)project);
        final String nexusUrl = envVars.expand(this.getNexusUrl());
        final String repository = envVars.expand(this.getRepository());
        final String expandedVersion = envVars.expand(this.getVersion());
        final String expandedGroupId = envVars.expand(this.getGroupId());
        if (this.artifacts == null || this.artifacts.size() == 0) {
            throw new IOException("No artifacts defined. Artifacts must be defined in addition to group id. See https://plugins.jenkins.io/nexus-artifact-uploader");
        }
        final LinkedHashMap<Artifact, File> artifactToFile = new LinkedHashMap<Artifact, File>();
        for (Artifact artifact : this.artifacts) {
            FilePath artifactFilePath = new FilePath(workspace, envVars.expand(artifact.getFile()));
            artifactToFile.put(artifact.expandVars(envVars), new File(artifactFilePath.getRemote()));
        }
        workspace.act((Callable)new Callable<Boolean, IOException>(){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ NexusArtifactUploader this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean call() throws IOException {
                ArrayList<org.sonatype.aether.artifact.Artifact> nexusArtifacts = new ArrayList<org.sonatype.aether.artifact.Artifact>(artifactToFile.size());
                for (Map.Entry entry : artifactToFile.entrySet()) {
                    Artifact artifact = (Artifact)entry.getKey();
                    File file = (File)entry.getValue();
                    if (!file.exists()) {
                        listener.getLogger().println(file.getName() + " file doesn't exist");
                        throw new IOException(file.getName() + " file doesn't exist");
                    }
                    nexusArtifacts.add(Utils.toArtifact(artifact, expandedGroupId, expandedVersion, file));
                }
                return Utils.uploadArtifacts(listener, username, password, nexusUrl, repository, this.this$0.protocol, this.this$0.nexusVersion, nexusArtifacts.toArray(new org.sonatype.aether.artifact.Artifact[0]));
            }

            public void checkRoles(RoleChecker checker) throws SecurityException {
            }
        });
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl<C extends StandardCredentials>
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Nexus artifact uploader";
        }

        public FormValidation doCheckNexusUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"URL must not be empty");
            }
            if (value.startsWith("http://") || value.startsWith("https://")) {
                return FormValidation.error((String)"URL must not start with http:// or https://");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"GroupId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Version must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRepository(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Repository must not be empty");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public ListBoxModel doFillNexusVersionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("NEXUS2", "nexus2");
            items.add("NEXUS3", "nexus3");
            return items;
        }

        public ListBoxModel doFillProtocolItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("HTTP", "http");
            items.add("HTTPS", "https");
            return items;
        }
    }
}

