/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader.steps;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import sp.sd.nexusartifactuploader.Artifact;
import sp.sd.nexusartifactuploader.Utils;

public final class NexusArtifactUploaderStep
extends AbstractStepImpl {
    private final String nexusVersion;
    private final String protocol;
    private final String nexusUrl;
    private final String groupId;
    private final String version;
    private final String repository;
    private final List<Artifact> artifacts;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public NexusArtifactUploaderStep(String nexusVersion, String protocol, String nexusUrl, String groupId, String version, String repository, String credentialsId, List<Artifact> artifacts) {
        this.nexusVersion = nexusVersion;
        this.protocol = protocol;
        this.nexusUrl = nexusUrl;
        this.groupId = groupId;
        this.version = version;
        this.repository = repository;
        this.credentialsId = credentialsId;
        this.artifacts = artifacts;
    }

    public String getNexusVersion() {
        return this.nexusVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRepository() {
        return this.repository;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials(Item project) {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = this.credentialsId == null ? null : (credentials = NexusArtifactUploaderStep.lookupSystemCredentials(this.credentialsId, project));
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId, Item project) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(EnvVars environment, Item project) {
        String Username = "";
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Username = this.getCredentials(project).getUsername();
        }
        return Username;
    }

    public String getPassword(EnvVars environment, Item project) {
        String Password = "";
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials(project))).getPassword());
        }
        return Password;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient NexusArtifactUploaderStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;

        protected Boolean run() throws Exception {
            Job project = this.build.getParent();
            EnvVars envVars = this.build.getEnvironment(this.listener);
            final String username = this.step.getUsername(envVars, (Item)project);
            final String password = this.step.getPassword(envVars, (Item)project);
            final String nexusUrl = envVars.expand(this.step.getNexusUrl());
            final String repository = envVars.expand(this.step.getRepository());
            final String groupId = envVars.expand(this.step.getGroupId());
            final String version = envVars.expand(this.step.getVersion());
            final String protocol = this.step.getProtocol();
            final String nexusVersion = this.step.getNexusVersion();
            final TaskListener listener = this.listener;
            final LinkedHashMap<Artifact, File> artifactToFile = new LinkedHashMap<Artifact, File>();
            for (Artifact artifact : this.step.artifacts) {
                FilePath artifactFilePath = new FilePath(this.ws, envVars.expand(artifact.getFile()));
                artifactToFile.put(artifact.expandVars(envVars), new File(artifactFilePath.getRemote()));
            }
            return (Boolean)this.ws.act((Callable)new Callable<Boolean, Exception>(){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ Execution this$0;
                {
                    this.this$0 = this$0;
                }

                public Boolean call() throws Exception {
                    ArrayList<org.sonatype.aether.artifact.Artifact> nexusArtifacts = new ArrayList<org.sonatype.aether.artifact.Artifact>(artifactToFile.size());
                    for (Map.Entry entry : artifactToFile.entrySet()) {
                        Artifact artifact = (Artifact)entry.getKey();
                        File file = (File)entry.getValue();
                        if (!file.exists()) {
                            listener.getLogger().println(file.getName() + " file doesn't exist");
                            throw new IOException(file.getName() + " file doesn't exist");
                        }
                        nexusArtifacts.add(Utils.toArtifact(artifact, groupId, version, file));
                    }
                    return Utils.uploadArtifacts(listener, username, password, nexusUrl, repository, protocol, nexusVersion, nexusArtifacts.toArray(new org.sonatype.aether.artifact.Artifact[0]));
                }

                public void checkRoles(RoleChecker checker) throws SecurityException {
                }
            });
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "nexusArtifactUploader";
        }

        public String getDisplayName() {
            return "Nexus Artifact Uploader";
        }

        public FormValidation doCheckNexusUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"URL must not be empty");
            }
            if (value.startsWith("http://") || value.startsWith("https://")) {
                return FormValidation.error((String)"URL must not start with http:// or https://");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"GroupId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Version must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRepository(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Repository must not be empty");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }

        public ListBoxModel doFillNexusVersionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("NEXUS2", "nexus2");
            items.add("NEXUS3", "nexus3");
            return items;
        }

        public ListBoxModel doFillProtocolItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("HTTP", "http");
            items.add("HTTPS", "https");
            return items;
        }
    }
}

