/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Artifact
extends AbstractDescribableImpl<Artifact>
implements Serializable {
    private static final long serialVersionUID = 1905162041950251407L;
    private final String artifactId;
    private final String type;
    private final String classifier;
    private final String file;

    @DataBoundConstructor
    public Artifact(String artifactId, String type, String classifier, String file) {
        this.artifactId = artifactId;
        this.type = type;
        this.classifier = classifier;
        this.file = file != null ? file.trim() : null;
    }

    @CheckReturnValue
    public Artifact expandVars(EnvVars envVars) {
        return new Artifact(envVars.expand(this.artifactId), envVars.expand(this.type), envVars.expand(this.classifier), envVars.expand(this.file));
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getFile() {
        return this.file;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Artifact> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckArtifactId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"ArtifactId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckType(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Type must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClassifier(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"File must not be empty");
            }
            return FormValidation.ok();
        }
    }
}

