/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import hudson.model.TaskListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class TransferListener
extends AbstractTransferListener {
    Logger logger = LoggerFactory.getLogger(TransferListener.class);
    private ConcurrentMap<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;
    private TaskListener Listener;
    int lastPercentage = 0;

    public TransferListener(TaskListener Listener) {
        this.Listener = Listener;
    }

    public void transferInitiated(TransferEvent event) {
        String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        TransferResource resource = event.getResource();
        this.Listener.getLogger().println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.Listener.getLogger().println("[WARNING] " + event.getException().getMessage() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat(Locale.ENGLISH);
        String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String len = format.format(contentLength);
        Object throughput = "";
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            throughput = " at " + format.format((long)bytesPerSecond) + "/s";
        }
        this.Listener.getLogger().println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + (String)throughput + ")");
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry entry : this.downloads.entrySet()) {
            long total = ((TransferResource)entry.getKey()).getContentLength();
            long complete = (Long)entry.getValue();
            long percentageComplete = complete * 100L / total;
            if (percentageComplete < (long)(this.lastPercentage + 10)) continue;
            buffer.append(percentageComplete).append(" ");
            this.lastPercentage = (int)percentageComplete;
            this.Listener.getLogger().println(String.valueOf(buffer) + "% completed (" + this.getStatus(complete, total) + ").");
        }
    }

    private String getStatus(long complete, long total) {
        FileSizeFormat format = new FileSizeFormat(Locale.ENGLISH);
        if (total >= 1024L) {
            return format.format(complete) + " / " + format.format(total);
        }
        if (total >= 0L) {
            return format.format(complete) + " / " + format.format(total);
        }
        if (complete >= 1024L) {
            return format.format(complete);
        }
        return format.format(complete);
    }

    static class FileSizeFormat {
        private DecimalFormat smallFormat;
        private DecimalFormat largeFormat;

        public FileSizeFormat(Locale locale) {
            this.smallFormat = new DecimalFormat("#0.0", new DecimalFormatSymbols(locale));
            this.largeFormat = new DecimalFormat("###0", new DecimalFormatSymbols(locale));
        }

        public String format(long size) {
            return this.format(size, null);
        }

        public String format(long size, ScaleUnit unit) {
            return this.format(size, unit, false);
        }

        public String format(long size, ScaleUnit unit, boolean omitSymbol) {
            Validate.isTrue((size >= 0L ? 1 : 0) != 0, (String)"File size cannot be negative: %s", (long)size);
            if (unit == null) {
                unit = ScaleUnit.getScaleUnit(size);
            }
            double scaledSize = (double)size / (double)unit.bytes();
            Object scaledSymbol = " " + unit.symbol();
            if (omitSymbol) {
                scaledSymbol = "";
            }
            if (unit == ScaleUnit.BYTE) {
                return this.largeFormat.format(size) + (String)scaledSymbol;
            }
            if (scaledSize < 0.05 || scaledSize >= 10.0) {
                return this.largeFormat.format(scaledSize) + (String)scaledSymbol;
            }
            return this.smallFormat.format(scaledSize) + (String)scaledSymbol;
        }

        public String formatProgress(long progressedSize, long size) {
            Validate.isTrue((progressedSize >= 0L ? 1 : 0) != 0, (String)"Progressed file size cannot be negative: %s", (long)progressedSize);
            Validate.isTrue((size < 0L || progressedSize <= size ? 1 : 0) != 0, (String)"Progressed file size cannot be bigger than size: %s > %s", (Object[])new Object[]{progressedSize, size});
            if (size >= 0L && progressedSize != size) {
                ScaleUnit unit = ScaleUnit.getScaleUnit(size);
                String formattedProgressedSize = this.format(progressedSize, unit, true);
                String formattedSize = this.format(size, unit);
                return formattedProgressedSize + "/" + formattedSize;
            }
            return this.format(progressedSize);
        }

        static enum ScaleUnit {
            BYTE{

                @Override
                public long bytes() {
                    return 1L;
                }

                @Override
                public String symbol() {
                    return "B";
                }
            }
            ,
            KILOBYTE{

                @Override
                public long bytes() {
                    return 1000L;
                }

                @Override
                public String symbol() {
                    return "kB";
                }
            }
            ,
            MEGABYTE{

                @Override
                public long bytes() {
                    return KILOBYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "MB";
                }
            }
            ,
            GIGABYTE{

                @Override
                public long bytes() {
                    return MEGABYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "GB";
                }
            };


            public abstract long bytes();

            public abstract String symbol();

            public static ScaleUnit getScaleUnit(long size) {
                Validate.isTrue((size >= 0L ? 1 : 0) != 0, (String)"File size cannot be negative: %s", (long)size);
                if (size >= GIGABYTE.bytes()) {
                    return GIGABYTE;
                }
                if (size >= MEGABYTE.bytes()) {
                    return MEGABYTE;
                }
                if (size >= KILOBYTE.bytes()) {
                    return KILOBYTE;
                }
                return BYTE;
            }
        }
    }
}

