/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.flywayrunner.installation;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.flywayrunner.installation.FlywayInstallation;

public class FlywayInstaller
extends DownloadFromUrlInstaller {
    private static final Logger LOG = Logger.getLogger(FlywayInstaller.class.getName());
    private String databaseDriverUrl;

    @DataBoundConstructor
    public FlywayInstaller(String id, String databaseDriverUrl) {
        super(id);
        this.databaseDriverUrl = databaseDriverUrl;
    }

    public FlywayInstaller(String id) {
        super(id);
    }

    public String getDatabaseDriverUrl() {
        return this.databaseDriverUrl;
    }

    public void setDatabaseDriverUrl(String databaseDriverUrl) {
        this.databaseDriverUrl = databaseDriverUrl;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath installationRoot = super.performInstallation(tool, node, log);
        if (!Strings.isNullOrEmpty((String)this.databaseDriverUrl)) {
            Iterable urls = Splitter.on((String)",").trimResults().split((CharSequence)this.databaseDriverUrl);
            for (String url : urls) {
                String filename = url.substring(this.databaseDriverUrl.lastIndexOf("/") + 1);
                FilePath child = installationRoot.child("drivers/" + filename);
                if (child.exists()) continue;
                log.getLogger().println("Downloading " + this.databaseDriverUrl + " to " + String.valueOf(child) + " on " + node.getDisplayName());
                URL downloadUrl = new URL(this.databaseDriverUrl);
                child.copyFrom(downloadUrl);
            }
        }
        return installationRoot;
    }

    @Extension
    public static final class FlywayInstallerDescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<FlywayInstaller> {
        public String getDisplayName() {
            return "Install from Maven Central";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == FlywayInstallation.class;
        }
    }
}

