/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.flywayrunner.installation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.PersistentDescriptor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class FlywayInstallation
extends ToolInstallation
implements NodeSpecific<FlywayInstallation>,
EnvironmentSpecific<FlywayInstallation> {
    private static final long serialVersionUID = 2L;
    private String flywayHome;

    @DataBoundConstructor
    public FlywayInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, FlywayInstallation.launderHome(home), properties);
        this.flywayHome = home;
    }

    public FlywayInstallation forEnvironment(EnvVars environment) {
        return new FlywayInstallation(this.getName(), environment.expand(this.flywayHome), this.getProperties().toList());
    }

    public FlywayInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new FlywayInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public static FlywayInstallation[] allInstallations() {
        DescriptorImpl ansibleDescriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        return (FlywayInstallation[])ansibleDescriptor.getInstallations();
    }

    public String getHome() {
        String resolvedHome = this.flywayHome != null ? this.flywayHome : super.getHome();
        return resolvedHome;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new GetExecutable(this.getHome()));
    }

    private static File getExecutableFile(String flywayHome) {
        File executable;
        File file = new File(flywayHome);
        if (file.isFile()) {
            executable = file;
        } else {
            String execName = Functions.isWindows() ? "flyway.cmd" : "flyway";
            String resolvedFlywayHome = Util.replaceMacro((String)flywayHome, (Map)EnvVars.masterEnvVars);
            executable = new File(resolvedFlywayHome, execName);
        }
        return executable;
    }

    private static String launderHome(String home) {
        if (home.endsWith("/") || home.endsWith("\\")) {
            return home.substring(0, home.length() - 1);
        }
        return home;
    }

    @Extension
    @Symbol(value={"flyway"})
    public static class DescriptorImpl
    extends ToolDescriptor<FlywayInstallation>
    implements PersistentDescriptor {
        public String getDisplayName() {
            return "Flyway";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }
    }

    private static class GetExecutable
    extends MasterToSlaveCallable<String, IOException> {
        private final String flywayHome;

        GetExecutable(String flywayHome) {
            this.flywayHome = flywayHome;
        }

        public String call() throws IOException {
            File exe = FlywayInstallation.getExecutableFile(this.flywayHome);
            if (exe.exists()) {
                return exe.getPath();
            }
            return null;
        }
    }
}

