/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.flywayrunner.builder;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.PersistentDescriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;
import sp.sd.flywayrunner.builder.CliOption;
import sp.sd.flywayrunner.builder.Util;
import sp.sd.flywayrunner.installation.FlywayInstallation;

public class FlywayBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private final String flywayCommand;
    private final String installationName;
    private final String url;
    private final String commandLineArgs;
    private final String locations;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public FlywayBuilder(String installationName, String flywayCommand, String url, String locations, String commandLineArgs, String credentialsId) {
        this.flywayCommand = flywayCommand;
        this.installationName = installationName;
        this.url = url;
        this.locations = locations;
        this.commandLineArgs = commandLineArgs;
        this.credentialsId = credentialsId;
    }

    public FlywayInstallation getInstallation() {
        for (FlywayInstallation i : this.getDescriptor().getInstallations()) {
            if (this.installationName == null || !this.installationName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean result = false;
        ArgumentListBuilder cliCommand = this.composeFlywayCommand(build, listener, launcher, workspace);
        if (cliCommand != null) {
            int exitStatus = launcher.launch().cmds(cliCommand).stdout(listener).join();
            result = this.didErrorsOccur(exitStatus);
        }
        if (!result) {
            throw new AbortException("Build step 'Invoke Flyway' failed due to errors.");
        }
    }

    private ArgumentListBuilder composeFlywayCommand(Run<?, ?> build, TaskListener listener, Launcher launcher, FilePath workspace) {
        ArgumentListBuilder cliCommand = new ArgumentListBuilder();
        Job project = build.getParent();
        try {
            FlywayInstallation installation = this.getInstallation();
            if (installation != null) {
                FlywayInstallation buildTool = Util.getInstallation(installation, build.getEnvironment(listener), listener, workspace);
                cliCommand.add(buildTool.getExecutable(launcher));
                Util.addOptionIfPresent(cliCommand, CliOption.USERNAME, this.getUsername((Item)project));
                cliCommand.addMasked("-" + CliOption.PASSWORD.getCliOption() + "=" + this.getCredentialsPassword((Item)project));
                Util.addOptionIfPresent(cliCommand, CliOption.URL, build.getEnvironment(listener).expand(this.url));
                Util.addOptionIfPresent(cliCommand, CliOption.LOCATIONS, build.getEnvironment(listener).expand(this.locations));
                if (!Strings.isNullOrEmpty((String)this.commandLineArgs)) {
                    cliCommand.addTokenized(build.getEnvironment(listener).expand(this.commandLineArgs));
                }
            } else {
                listener.fatalError("Flyway installation was not found.");
                return null;
            }
            cliCommand.addTokenized(build.getEnvironment(listener).expand(this.flywayCommand));
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
        }
        return cliCommand;
    }

    private boolean didErrorsOccur(int exitStatus) {
        boolean result = true;
        if (exitStatus != 0) {
            result = false;
        }
        return result;
    }

    public String getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public String getFlywayCommand() {
        return this.flywayCommand;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getLocations() {
        return this.locations;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials(Item project) {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = credentials = this.credentialsId == null ? null : this.lookupSystemCredentials(this.credentialsId, project);
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public StandardUsernameCredentials lookupSystemCredentials(String credentialsId, Item project) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)project, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(Item project) {
        String username = null;
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            username = this.getCredentials(project).getUsername();
        }
        return username;
    }

    public String getCredentialsPassword(Item project) {
        String password = null;
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials(project))).getPassword());
        }
        return password;
    }

    @Extension
    @Symbol(value={"flywayrunner"})
    public static final class DescriptorImpl<C extends StandardCredentials>
    extends BuildStepDescriptor<Builder>
    implements PersistentDescriptor {
        public DescriptorImpl() {
            super(FlywayBuilder.class);
            this.load();
        }

        public FlywayInstallation[] getInstallations() {
            return FlywayInstallation.allInstallations();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Invoke Flyway";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, owner, StandardUsernamePasswordCredentials.class);
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (FlywayInstallation tool : FlywayInstallation.allInstallations()) {
                model.add(tool.getName());
            }
            return model;
        }
    }
}

