/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileJoinOperation
extends FileOperation
implements Serializable {
    private final String sourceFile;
    private final String targetFile;

    @DataBoundConstructor
    public FileJoinOperation(String sourceFile, String targetFile) {
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Join Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.sourceFile), envVars.expand(this.targetFile), envVars));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final EnvVars environment;
        private final String resolvedSourceFile;
        private final String resolvedTargetFile;

        public TargetFileCallable(TaskListener Listener, String ResolvedSourceFile, String ResolvedTargetFile, EnvVars environment) {
            this.listener = Listener;
            this.resolvedSourceFile = ResolvedSourceFile;
            this.resolvedTargetFile = ResolvedTargetFile;
            this.environment = environment;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result;
            try {
                String eol;
                FilePath fpWS = new FilePath(ws);
                FilePath fpSL = new FilePath(fpWS, this.resolvedSourceFile);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetFile);
                if (!fpTL.exists()) {
                    this.listener.getLogger().println(this.resolvedSourceFile + " file doesn't exists, the target file remains as is.");
                }
                String fileContent = "";
                String sourceFileContents = fpSL.readToString();
                String targetFileContents = fpTL.readToString();
                fileContent = targetFileContents.endsWith(eol = System.getProperty("line.separator")) ? targetFileContents.concat(sourceFileContents) : targetFileContents.concat(eol + sourceFileContents);
                fpTL.write(fileContent, "UTF-8");
                result = true;
                this.listener.getLogger().println("Joining file: from source " + fpSL.getRemote() + " to target " + fpTL.getRemote());
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    @Extension
    @Symbol(value={"fileJoinOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Join";
        }
    }
}

