/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileCreateOperation
extends FileOperation
implements Serializable {
    private final String fileName;
    private final String fileContent;

    @DataBoundConstructor
    public FileCreateOperation(String fileName, String fileContent) {
        this.fileName = fileName;
        this.fileContent = fileContent;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Create Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.fileName), envVars.expand(this.fileContent), envVars));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final EnvVars environment;
        private final String resolvedFileName;
        private final String resolvedFileContent;

        public TargetFileCallable(TaskListener Listener, String ResolvedFileName, String ResolvedFileContent, EnvVars environment) {
            this.listener = Listener;
            this.resolvedFileName = ResolvedFileName;
            this.resolvedFileContent = ResolvedFileContent;
            this.environment = environment;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpTL = new FilePath(fpWS, this.resolvedFileName);
                if (fpTL.exists()) {
                    this.listener.getLogger().println(this.resolvedFileName + " file already exists, replacing the content with the provided content.");
                }
                this.listener.getLogger().println("Creating file: " + fpTL.getRemote());
                fpTL.write(this.resolvedFileContent, "UTF-8");
                result = true;
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    @Extension
    @Symbol(value={"fileCreateOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Create";
        }
    }
}

