/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.Util;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class BuildParameterCondition
extends Condition {
    private static final Logger LOG = Logger.getLogger(BuildParameterCondition.class.getName());
    private String parameterName;
    private String parameterValue;

    @DataBoundConstructor
    public BuildParameterCondition() {
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @DataBoundSetter
    public void setParameterName(String parameterName) {
        this.parameterName = Util.fixNull((String)parameterName);
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    @DataBoundSetter
    public void setParameterValue(String parameterValue) {
        this.parameterValue = Util.fixNull((String)parameterValue);
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        if (StringUtils.isEmpty((String)this.parameterName)) {
            LOG.log(Level.WARNING, () -> String.format("Parameter name is empty for job %s", this.parameterName, run.getDisplayName()));
            return false;
        }
        if (StringUtils.isEmpty((String)this.parameterValue)) {
            LOG.log(Level.WARNING, () -> String.format("Parameter value is empty for job %s", this.parameterName, run.getDisplayName()));
            return false;
        }
        ParameterValue parameter = this.getParameter(run);
        if (parameter == null) {
            LOG.log(Level.WARNING, () -> String.format("Parameter %s is not present for job %s", this.parameterName, run.getDisplayName()));
            return false;
        }
        Object buildValue = parameter.getValue();
        if (buildValue == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(this.parameterValue);
        return pattern.matcher(buildValue.toString()).matches();
    }

    ParameterValue getParameter(Run<?, ?> run) {
        Optional<ParameterValue> parameterValue = run.getParameterValues().stream().filter(param -> param.getName().equals(this.parameterName)).findFirst();
        if (parameterValue.isEmpty()) {
            return null;
        }
        return parameterValue.get();
    }
}

