/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.model.Run;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class FileScannerCondition
extends Condition {
    private String includePattern = "";
    private String excludePattern = "";
    private boolean caseSensitive = true;

    @DataBoundConstructor
    public FileScannerCondition() {
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    @DataBoundSetter
    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @DataBoundSetter
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        String[] includes = new String[]{this.includePattern};
        String[] excludes = new String[]{this.excludePattern};
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        ds.setExcludes(excludes);
        ds.setCaseSensitive(this.caseSensitive);
        ds.setBasedir(run.getRootDir());
        ds.scan();
        return ds.getIncludedFilesCount() > 0;
    }
}

