/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jelly.XMLOutput;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.xml.sax.ContentHandler;

public class HTMLWriterOutput
extends XMLOutput {
    private HTMLWriter htmlWriter;
    private OutputFormat format;
    private static final Logger LOGGER = Logger.getLogger(HTMLWriterOutput.class.getName());

    public static HTMLWriterOutput create(OutputStream out) throws UnsupportedEncodingException {
        OutputFormat format = HTMLWriterOutput.createFormat();
        return new HTMLWriterOutput(new HTMLWriter(out, format), format, false);
    }

    public static HTMLWriterOutput create(Writer out, boolean escapeText) {
        OutputFormat format = HTMLWriterOutput.createFormat();
        return new HTMLWriterOutput(new HTMLWriter(out, format), format, escapeText);
    }

    private static OutputFormat createFormat() {
        OutputFormat format = new OutputFormat();
        format.setXHTML(true);
        format.setExpandEmptyElements(true);
        return format;
    }

    private HTMLWriterOutput(HTMLWriter hw, OutputFormat fmt, boolean escapeText) {
        super((ContentHandler)hw);
        hw.setEscapeText(escapeText);
        this.htmlWriter = hw;
        this.format = fmt;
        this.format.setExpandEmptyElements(true);
    }

    public void close() throws IOException {
        this.htmlWriter.close();
    }

    @Deprecated
    public void useHTML(boolean enabled) {
        LOGGER.log(Level.WARNING, null, new UnsupportedOperationException("Deprecated: HTMLWriterOutput.useHtml() has been deprecated and its functionality removed."));
    }
}

