/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.adjunct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.framework.adjunct.Adjunct;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.framework.adjunct.NoSuchAdjunctException;
import org.xml.sax.SAXException;

public class AdjunctsInPage {
    private final AdjunctManager manager;
    private final Set<String> included = new HashSet<String>();
    private final List<Adjunct> pending = new ArrayList<Adjunct>();
    private final StaplerRequest2 request;
    private static final String KEY = AdjunctsInPage.class.getName();
    private static final Logger LOGGER = Logger.getLogger(AdjunctsInPage.class.getName());

    public static AdjunctsInPage get() {
        return AdjunctsInPage.get(Stapler.getCurrentRequest2());
    }

    public static AdjunctsInPage get(StaplerRequest2 request) {
        AdjunctsInPage aip = (AdjunctsInPage)request.getAttribute(KEY);
        if (aip == null) {
            aip = new AdjunctsInPage(AdjunctManager.get(request.getServletContext()), request);
            request.setAttribute(KEY, (Object)aip);
        }
        return aip;
    }

    private AdjunctsInPage(AdjunctManager manager, StaplerRequest2 request) {
        this.manager = manager;
        this.request = request;
    }

    public Set<String> getIncluded() {
        return Collections.unmodifiableSet(this.included);
    }

    public boolean isIncluded(String include) {
        return this.included.contains(include);
    }

    public void generate(XMLOutput out, String ... includes) throws IOException, SAXException {
        ArrayList<Adjunct> needed = new ArrayList<Adjunct>();
        for (String include : includes) {
            this.findNeeded(include, needed);
        }
        for (Adjunct adj : needed) {
            adj.write(this.request, out);
        }
    }

    public void assumeIncluded(String ... includes) throws IOException, SAXException {
        this.assumeIncluded(Arrays.asList(includes));
    }

    public void assumeIncluded(Collection<String> includes) throws IOException, SAXException {
        ArrayList<Adjunct> needed = new ArrayList<Adjunct>();
        for (String include : includes) {
            this.findNeeded(include, needed);
        }
    }

    public void spool(String ... includes) throws IOException, SAXException {
        for (String include : includes) {
            this.findNeeded(include, this.pending);
        }
    }

    public void writeSpooled(XMLOutput out) throws SAXException, IOException {
        for (Adjunct adj : this.pending) {
            adj.write(this.request, out);
        }
        this.pending.clear();
    }

    private void findNeeded(String include, List<Adjunct> needed) throws IOException {
        if (!this.included.add(include)) {
            return;
        }
        try {
            Adjunct a = this.manager.get(include);
            for (String req : a.required) {
                this.findNeeded(req, needed);
            }
            needed.add(a);
        }
        catch (NoSuchAdjunctException e) {
            LOGGER.log(Level.WARNING, "No such adjunct found: " + include, e);
        }
    }
}

