/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.adjunct;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.framework.adjunct.Adjunct;

public class AdjunctManager {
    private final ConcurrentHashMap<String, Adjunct> adjuncts = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<String> allowedResources = new ConcurrentSkipListSet();
    private final ClassLoader classLoader;
    public final String rootURL;
    public boolean debug = Boolean.getBoolean(AdjunctManager.class.getName() + ".debug");
    public final WebApp webApp;
    private final long expiration;
    private static final String KEY = AdjunctManager.class.getName();

    @Deprecated
    public AdjunctManager(ServletContext context, ClassLoader classLoader, String rootURL) {
        this(context, classLoader, rootURL, 86400000L);
    }

    public AdjunctManager(ServletContext context, ClassLoader classLoader, String rootURL, long expiration) {
        this.classLoader = classLoader;
        this.rootURL = rootURL;
        this.webApp = WebApp.get((ServletContext)context);
        this.expiration = expiration;
        context.setAttribute(KEY, (Object)this);
    }

    public static AdjunctManager get(ServletContext context) {
        return (AdjunctManager)context.getAttribute(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Adjunct get(String name) throws IOException {
        Adjunct a = this.adjuncts.get(name);
        if (a != null) {
            return a;
        }
        AdjunctManager adjunctManager = this;
        synchronized (adjunctManager) {
            a = this.adjuncts.get(name);
            if (a != null) {
                return a;
            }
            a = new Adjunct(this, name, this.classLoader);
            this.adjuncts.put(name, a);
            return a;
        }
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        URL res;
        String path = req.getRestOfPath();
        if (path.isEmpty()) {
            throw HttpResponses.error((int)404, (Throwable)new IllegalArgumentException("No adjunct provided"));
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (!this.allowedResources.contains(path)) {
            if (!this.allowResourceToBeServed(path)) {
                rsp.sendError(403);
                return;
            }
            this.allowedResources.add(path);
        }
        if ((res = this.classLoader.getResource(path)) == null) {
            throw HttpResponses.error((int)404, (Throwable)new IllegalArgumentException("No such adjunct found: " + path));
        }
        long expires = MetaClass.NO_CACHE ? 0L : this.expiration;
        rsp.serveFile(req, res, expires);
    }

    protected boolean allowResourceToBeServed(String absolutePath) {
        int idx = absolutePath.lastIndexOf(47);
        if (idx > 0 && this.classLoader.getResource(absolutePath.substring(0, idx) + "/.adjunct") != null) {
            return true;
        }
        return absolutePath.endsWith(".gif") || absolutePath.endsWith(".png") || absolutePath.endsWith(".css") || absolutePath.endsWith(".js");
    }
}

