/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.JsonEventListener;

abstract class AbstractJSON
implements JSON {
    private static CycleSet cycleSet = new CycleSet();
    private static final Logger logger = Logger.getLogger(AbstractJSON.class.getName());
    private static final WritingVisitor NORMAL = new WritingVisitor(){

        @Override
        public Collection keySet(JSONObject o) {
            return o.keySet();
        }

        @Override
        public void on(JSON o, Writer w) throws IOException {
            o.write(w);
        }

        @Override
        public void on(Object value, Writer w) throws IOException {
            w.write(JSONUtils.valueToString(value));
        }
    };
    private static final WritingVisitor CANONICAL = new WritingVisitor(){

        @Override
        public Collection keySet(JSONObject o) {
            return new TreeSet<String>(o.keySet());
        }

        @Override
        public void on(JSON o, Writer w) throws IOException {
            o.writeCanonical(w);
        }

        @Override
        public void on(Object value, Writer w) throws IOException {
            w.write(JSONUtils.valueToCanonicalString(value));
        }
    };

    AbstractJSON() {
    }

    protected static boolean addInstance(Object instance) {
        return AbstractJSON.getCycleSet().add(instance);
    }

    protected static void fireArrayEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onArrayEnd();
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireArrayStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onArrayStart();
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireElementAddedEvent(int index, Object element, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onElementAdded(index, element);
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireErrorEvent(JSONException jsone, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onError(jsone);
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireObjectEndEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onObjectEnd();
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireObjectStartEvent(JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onObjectStart();
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void firePropertySetEvent(String key, Object value, boolean accumulated, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onPropertySet(key, value, accumulated);
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void fireWarnEvent(String warning, JsonConfig jsonConfig) {
        if (jsonConfig.isEventTriggeringEnabled()) {
            for (Object o : jsonConfig.getJsonEventListeners()) {
                JsonEventListener listener = (JsonEventListener)o;
                try {
                    listener.onWarning(warning);
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    protected static void removeInstance(Object instance) {
        Set set = AbstractJSON.getCycleSet();
        set.remove(instance);
        if (set.size() == 0) {
            cycleSet.remove();
        }
    }

    protected Object _processValue(Object value, JsonConfig jsonConfig) {
        if (JSONNull.getInstance().equals(value)) {
            return JSONNull.getInstance();
        }
        if (Class.class.isAssignableFrom(value.getClass()) || value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof JSONString) {
            return JSONSerializer.toJSON((Object)((JSONString)value), jsonConfig);
        }
        if (value instanceof JSON) {
            return JSONSerializer.toJSON(value, jsonConfig);
        }
        if (JSONUtils.isArray(value)) {
            return JSONArray.fromObject(value, jsonConfig);
        }
        if (JSONUtils.isString(value)) {
            return value.toString();
        }
        if (JSONUtils.isNumber(value)) {
            JSONUtils.testValidity(value);
            return JSONUtils.transformNumber((Number)value);
        }
        if (JSONUtils.isBoolean(value)) {
            return value;
        }
        JSONObject jsonObject = JSONObject.fromObject(value, jsonConfig);
        if (jsonObject.isNullObject()) {
            return JSONNull.getInstance();
        }
        return jsonObject;
    }

    private static Set getCycleSet() {
        return cycleSet.getSet();
    }

    @Override
    public final Writer write(Writer writer) throws IOException {
        this.write(writer, NORMAL);
        return writer;
    }

    @Override
    public final Writer writeCanonical(Writer writer) throws IOException {
        this.write(writer, CANONICAL);
        return writer;
    }

    protected abstract void write(Writer var1, WritingVisitor var2) throws IOException;

    private static class CycleSet
    extends ThreadLocal {
        private CycleSet() {
        }

        protected Object initialValue() {
            return new SoftReference(new HashSet());
        }

        public Set getSet() {
            HashSet set = (HashSet)((SoftReference)this.get()).get();
            if (set == null) {
                set = new HashSet();
                this.set(new SoftReference(set));
            }
            return set;
        }
    }

    static interface WritingVisitor {
        public Collection keySet(JSONObject var1);

        public void on(JSON var1, Writer var2) throws IOException;

        public void on(Object var1, Writer var2) throws IOException;
    }
}

