/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.ObjectMorpher;

public class SwitchingMorpher
implements ObjectMorpher {
    private Map classMap = new HashMap();
    private MorpherRegistry morpherRegistry;

    public SwitchingMorpher(Map classMap, MorpherRegistry morpherRegistry) {
        this.morpherRegistry = morpherRegistry;
        if (classMap == null || classMap.isEmpty()) {
            throw new MorphException("Must specify at least one mapping");
        }
        this.classMap.putAll(classMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchingMorpher)) {
            return false;
        }
        SwitchingMorpher other = (SwitchingMorpher)obj;
        if (this.classMap.size() != other.classMap.size()) {
            return false;
        }
        for (Map.Entry o : this.classMap.entrySet()) {
            Map.Entry entry = o;
            if (!other.classMap.containsKey(entry.getKey())) {
                return false;
            }
            if (entry.getValue().equals(other.classMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        Iterator iterator = this.classMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            result = 31 * result + Objects.hashCode(entry.getKey());
            result = 31 * result + Objects.hashCode(entry.getValue());
        }
        return result;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        Class target = (Class)this.classMap.get(value.getClass());
        return this.morpherRegistry.morph(target, value);
    }

    @Override
    public Class morphsTo() {
        return Object.class;
    }

    @Override
    public boolean supports(Class clazz) {
        return true;
    }
}

