/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.LongMorpher;

public final class LongArrayMorpher
extends AbstractArrayMorpher {
    private static final Class LONG_ARRAY_CLASS = long[].class;
    private long defaultValue;

    public LongArrayMorpher() {
        super(false);
    }

    public LongArrayMorpher(long defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongArrayMorpher)) {
            return false;
        }
        LongArrayMorpher other = (LongArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (LONG_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (long[])array;
        }
        if (array.getClass().isArray()) {
            LongMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Long.TYPE, dimensions);
            LongMorpher longMorpher = morpher = this.isUseDefault() ? new LongMorpher(this.defaultValue) : new LongMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.setLong(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return LONG_ARRAY_CLASS;
    }
}

