/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.file_leak_detector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.instrument.Instrumentation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipFile;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.file_leak_detector.ActivityListener;
import org.kohsuke.file_leak_detector.Listener;
import org.kohsuke.file_leak_detector.transform.ClassTransformSpec;
import org.kohsuke.file_leak_detector.transform.CodeGenerator;
import org.kohsuke.file_leak_detector.transform.MethodAppender;
import org.kohsuke.file_leak_detector.transform.TransformerImpl;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;

public class AgentMain {
    public static void agentmain(String agentArguments, Instrumentation instrumentation) throws Exception {
        AgentMain.premain(agentArguments, instrumentation);
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) throws Exception {
        int serverPort = -1;
        if (agentArguments != null) {
            boolean quit = true;
            block5: for (String t : agentArguments.split(",")) {
                if (t.equals("noexit")) {
                    quit = false;
                    continue;
                }
                if (t.equals("help")) {
                    AgentMain.usage();
                    if (quit) {
                        System.exit(-1);
                        continue;
                    }
                    return;
                }
                if (t.startsWith("threshold=")) {
                    Listener.THRESHOLD = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                    continue;
                }
                if (t.equals("trace")) {
                    Listener.TRACE = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset()));
                    continue;
                }
                if (t.equals("strong")) {
                    Listener.makeStrong();
                    continue;
                }
                if (t.startsWith("http=")) {
                    serverPort = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                    continue;
                }
                if (t.startsWith("trace=")) {
                    Listener.TRACE = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(t.substring(6)), StandardCharsets.UTF_8));
                    continue;
                }
                if (t.startsWith("error=")) {
                    Listener.ERROR = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(t.substring(6)), StandardCharsets.UTF_8));
                    continue;
                }
                if (t.startsWith("listener=")) {
                    ActivityListener.LIST.add((ActivityListener)AgentMain.class.getClassLoader().loadClass(t.substring(9)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (t.equals("dumpatshutdown")) {
                    Runtime.getRuntime().addShutdownHook(new Thread("File handles dumping shutdown hook"){

                        @Override
                        public void run() {
                            Listener.dump(System.err);
                        }
                    });
                    continue;
                }
                if (t.startsWith("excludes=")) {
                    try (BufferedReader reader = Files.newBufferedReader(Paths.get(t.substring(9), new String[0]), StandardCharsets.UTF_8);){
                        while (true) {
                            String line;
                            if ((line = reader.readLine()) == null) {
                                continue block5;
                            }
                            String str = line.trim();
                            if (str.isEmpty() || str.startsWith("#")) continue;
                            Listener.EXCLUDES.add(str);
                        }
                    }
                }
                System.err.println("Unknown option: " + t);
                AgentMain.usage();
                if (quit) {
                    System.exit(-1);
                }
                throw new CmdLineException("Unknown option: " + t);
            }
        }
        Listener.EXCLUDES.add("sun.nio.ch.PipeImpl$Initializer$LoopbackConnector.run");
        System.err.println("File leak detector installed");
        ActivityListener.LIST.size();
        Listener.AGENT_INSTALLED = true;
        instrumentation.addTransformer(new TransformerImpl(AgentMain.createSpec()), true);
        ArrayList classes = new ArrayList();
        Collections.addAll(classes, FileInputStream.class, FileOutputStream.class, RandomAccessFile.class, ZipFile.class, AbstractSelectableChannel.class, AbstractInterruptibleChannel.class, FileChannel.class, AbstractSelector.class, Files.class);
        AgentMain.addIfFound(classes, "sun.nio.ch.SocketChannelImpl");
        AgentMain.addIfFound(classes, "sun.nio.ch.FileChannelImpl");
        AgentMain.addIfFound(classes, "java.net.AbstractPlainSocketImpl");
        AgentMain.addIfFound(classes, "java.net.PlainSocketImpl");
        AgentMain.addIfFound(classes, "sun.nio.fs.UnixDirectoryStream");
        AgentMain.addIfFound(classes, "sun.nio.fs.UnixSecureDirectoryStream");
        AgentMain.addIfFound(classes, "sun.nio.fs.WindowsDirectoryStream");
        AgentMain.addIfFound(classes, "jdk.internal.jrtfs.JrtDirectoryStream");
        AgentMain.addIfFound(classes, "jdk.nio.zipfs.ZipDirectoryStream");
        instrumentation.retransformClasses(classes.toArray(new Class[0]));
        if (serverPort >= 0) {
            AgentMain.runHttpServer(serverPort);
        }
    }

    private static void addIfFound(List<Class<?>> classes, String className) {
        try {
            classes.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void runHttpServer(int port) throws IOException {
        ServerSocket ss = new ServerSocket();
        try {
            ss.bind(new InetSocketAddress("localhost", port));
        }
        catch (IOException e) {
            throw new IOException("While binding to localhost:" + port, e);
        }
        System.err.println("Serving file leak stats on http://localhost:" + ss.getLocalPort() + "/ for stats");
        ExecutorService es = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        es.submit(() -> {
            while (true) {
                Socket s = ss.accept();
                es.submit(() -> {
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream(), StandardCharsets.UTF_8));
                        in.readLine();
                        PrintWriter w = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), StandardCharsets.UTF_8));
                        w.print("HTTP/1.0 200 OK\r\nContent-Type: text/plain;charset=UTF-8\r\n\r\n");
                        Listener.dump(w);
                    }
                    finally {
                        s.close();
                    }
                    return null;
                });
            }
        });
    }

    private static void usage() {
        System.err.println("File leak detector arguments (to specify multiple values, separate them by ',':");
        AgentMain.printOptions();
    }

    static void printOptions() {
        System.err.println("  help           - Show the help screen.");
        System.err.println("  noexit         - Don't exit after showing the help screen.");
        System.err.println("  trace          - Log every open/close operation to stderr.");
        System.err.println("  trace=FILE     - Log every open/close operation to the given file.");
        System.err.println("  error=FILE     - If 'too many open files' error is detected, send the dump here.");
        System.err.println("                   By default it goes to stderr.");
        System.err.println("  threshold=N    - Instead of waiting until 'too many open files', dump once");
        System.err.println("                   we have N descriptors open.");
        System.err.println("  http=PORT      - Run a mini HTTP server that you can access to get stats on demand.");
        System.err.println("                   Specify 0 to choose random available port, -1 to disable, which is default.");
        System.err.println("  strong         - Don't let GC auto-close leaking file descriptors.");
        System.err.println("  listener=S     - Specify the fully qualified name of ActivityListener class to activate from beginning.");
        System.err.println("  dumpatshutdown - Dump open file handles at shutdown.");
        System.err.println("  excludes=FILE  - Ignore files opened directly/indirectly in specific methods.");
        System.err.println("                   File lists 'some.pkg.ClassName.methodName' patterns.");
    }

    static List<ClassTransformSpec> createSpec() {
        ArrayList<ClassTransformSpec> spec = new ArrayList<ClassTransformSpec>();
        Collections.addAll(spec, AgentMain.newSpec(FileOutputStream.class, "(Ljava/io/File;Z)V"), AgentMain.newSpec(FileInputStream.class, "(Ljava/io/File;)V"), AgentMain.newSpec(RandomAccessFile.class, "(Ljava/io/File;Ljava/lang/String;)V"), AgentMain.newSpec(ZipFile.class, "(Ljava/io/File;I)V"), new ClassTransformSpec(FileChannel.class, new ReturnFromStaticMethodInterceptor("open", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;", 4, "openFileChannel", FileChannel.class, Path.class)), new ClassTransformSpec(Files.class, new ReturnFromStaticMethodInterceptor("newByteChannel", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", 4, "openFileChannel", SeekableByteChannel.class, Path.class), new ReturnFromStaticMethodInterceptor("newDirectoryStream", "(Ljava/nio/file/Path;)Ljava/nio/file/DirectoryStream;", 2, "openDirectoryStream", DirectoryStream.class, Path.class), new ReturnFromStaticMethodInterceptor("newDirectoryStream", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/DirectoryStream;", 6, "openDirectoryStream", DirectoryStream.class, Path.class), new ReturnFromStaticMethodInterceptor("newDirectoryStream", "(Ljava/nio/file/Path;Ljava/nio/file/DirectoryStream$Filter;)Ljava/nio/file/DirectoryStream;", 3, "openDirectoryStream", DirectoryStream.class, Path.class)), new ClassTransformSpec(AbstractSelectableChannel.class, new ConstructorInterceptor("(Ljava/nio/channels/spi/SelectorProvider;)V", "openPipe")), new ClassTransformSpec(AbstractInterruptibleChannel.class, new CloseInterceptor("close")));
        if (!System.getProperty("os.name").startsWith("Windows")) {
            Collections.addAll(spec, new ClassTransformSpec("sun/nio/fs/UnixDirectoryStream", new CloseInterceptor("close")), new ClassTransformSpec("sun/nio/fs/UnixSecureDirectoryStream", new CloseInterceptor("close")));
        } else {
            Collections.addAll(spec, new ClassTransformSpec("sun/nio/fs/WindowsDirectoryStream", new CloseInterceptor("close")));
        }
        spec.add(new ClassTransformSpec("jdk/internal/jrtfs/JrtDirectoryStream", new CloseInterceptor("close")));
        spec.add(new ClassTransformSpec("jdk/nio/zipfs/ZipDirectoryStream", new CloseInterceptor("close")));
        spec.add(new ClassTransformSpec(AbstractSelector.class, new ConstructorInterceptor("(Ljava/nio/channels/spi/SelectorProvider;)V", "openSelector"), new CloseInterceptor("close")));
        if (Runtime.version().feature() < 19) {
            spec.add(new ClassTransformSpec("java/net/PlainSocketImpl", new OpenSocketInterceptor("create", "(Z)V"), new AcceptInterceptor("accept", "(Ljava/net/SocketImpl;)V"), new CloseInterceptor("socketClose")));
            spec.add(new ClassTransformSpec("java/net/AbstractPlainSocketImpl", new OpenSocketInterceptor("create", "(Z)V"), new AcceptInterceptor("accept", "(Ljava/net/SocketImpl;)V"), new CloseInterceptor("socketClose")));
        }
        spec.add(new ClassTransformSpec("sun/nio/ch/SocketChannelImpl", new OpenSocketInterceptor("<init>", "(Ljava/nio/channels/spi/SelectorProvider;Ljava/io/FileDescriptor;Ljava/net/InetSocketAddress;)V"), new OpenSocketInterceptor("<init>", "(Ljava/nio/channels/spi/SelectorProvider;)V"), new CloseInterceptor("kill")));
        spec.add(new ClassTransformSpec("sun/nio/ch/FileChannelImpl", new ReturnFromStaticMethodInterceptor("open", "(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/io/Closeable;)Ljava/nio/channels/FileChannel;", 4, "openFileString", Object.class, FileDescriptor.class, String.class), new ReturnFromStaticMethodInterceptor("open", "(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;", 4, "openFileString", Object.class, FileDescriptor.class, String.class)));
        return spec;
    }

    private static ClassTransformSpec newSpec(Class<?> c, String constructorDesc) {
        String binName = c.getName().replace('.', '/');
        return new ClassTransformSpec(binName, new ConstructorOpenInterceptor(constructorDesc, binName), new CloseInterceptor("close"));
    }

    private static class ReturnFromStaticMethodInterceptor
    extends MethodAppender {
        private final String listenerMethod;
        private final Class<?>[] listenerMethodArgs;
        private final int returnLocalVarIndex;

        public ReturnFromStaticMethodInterceptor(String methodName, String methodDesc, int returnLocalVarIndex, String listenerMethod, Class<?> ... listenerMethodArgs) {
            super(methodName, methodDesc);
            this.returnLocalVarIndex = returnLocalVarIndex;
            this.listenerMethod = listenerMethod;
            this.listenerMethodArgs = listenerMethodArgs.length == 0 ? new Class[]{Object.class} : listenerMethodArgs;
        }

        @Override
        protected void append(CodeGenerator g) {
            int[] index = new int[this.listenerMethodArgs.length];
            index[0] = this.returnLocalVarIndex;
            for (int i = 1; i < index.length; ++i) {
                index[i] = i - 1;
            }
            Label start = new Label();
            Label end = new Label();
            g.visitLocalVariable("result", "java/lang/Object", null, start, end, this.returnLocalVarIndex);
            g.visitLabel(start);
            g.astore(this.returnLocalVarIndex);
            g.invokeAppStatic(Listener.class, this.listenerMethod, this.listenerMethodArgs, index);
            g.visitLabel(end);
            g.aload(this.returnLocalVarIndex);
        }
    }

    private static class ConstructorInterceptor
    extends MethodAppender {
        private final String listenerMethod;

        public ConstructorInterceptor(String constructorDesc, String listenerMethod) {
            super("<init>", constructorDesc);
            this.listenerMethod = listenerMethod;
        }

        @Override
        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, this.listenerMethod, new Class[]{Object.class}, new int[]{0});
        }
    }

    private static class CloseInterceptor
    extends MethodAppender {
        public CloseInterceptor(String methodName) {
            super(methodName, "()V");
        }

        @Override
        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "close", new Class[]{Object.class}, new int[]{0});
        }
    }

    private static class OpenSocketInterceptor
    extends MethodAppender {
        public OpenSocketInterceptor(String name, String desc) {
            super(name, desc);
        }

        @Override
        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                @Override
                protected boolean toIntercept(String owner, String name) {
                    return name.equals("socketCreate");
                }
            };
        }

        @Override
        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "openSocket", new Class[]{Object.class}, new int[]{0});
        }
    }

    private static class AcceptInterceptor
    extends MethodAppender {
        public AcceptInterceptor(String name, String desc) {
            super(name, desc);
        }

        @Override
        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                @Override
                protected boolean toIntercept(String owner, String name) {
                    return name.equals("socketAccept");
                }
            };
        }

        @Override
        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "openSocket", new Class[]{Object.class}, new int[]{1});
        }
    }

    private static class ConstructorOpenInterceptor
    extends MethodAppender {
        private final String binName;

        public ConstructorOpenInterceptor(String constructorDesc, String binName) {
            super("<init>", constructorDesc);
            this.binName = binName;
        }

        @Override
        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                @Override
                protected boolean toIntercept(String owner, String name) {
                    return owner.equals(binName) && name.startsWith("open");
                }

                @Override
                protected Class<? extends Exception> getExpectedException() {
                    return FileNotFoundException.class;
                }
            };
        }

        @Override
        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "open", new Class[]{Object.class, File.class}, new int[]{0, 1});
        }
    }

    private static abstract class OpenInterceptionAdapter
    extends MethodVisitor {
        private final LocalVariablesSorter lvs;
        private final MethodVisitor base;

        private OpenInterceptionAdapter(MethodVisitor base, int access, String desc) {
            super(589824);
            this.lvs = new LocalVariablesSorter(access, desc, base);
            this.mv = this.lvs;
            this.base = base;
        }

        protected abstract boolean toIntercept(String var1, String var2);

        protected Class<? extends Exception> getExpectedException() {
            return IOException.class;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.toIntercept(owner, name)) {
                Type exceptionType = Type.getType(this.getExpectedException());
                CodeGenerator g = new CodeGenerator(this.mv);
                Label s = new Label();
                Label e = new Label();
                Label h = new Label();
                Label tail = new Label();
                g.visitTryCatchBlock(s, e, h, exceptionType.getInternalName());
                g.visitLabel(s);
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                g._goto(tail);
                g.visitLabel(e);
                g.visitLabel(h);
                int ex = this.lvs.newLocal(exceptionType);
                g.dup();
                this.base.visitVarInsn(58, ex);
                g.invokeVirtual(exceptionType.getInternalName(), "getMessage", "()Ljava/lang/String;");
                g.ldc("Too many open files");
                g.invokeVirtual("java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z");
                Label rethrow = new Label();
                g.ifFalse(rethrow);
                g.invokeAppStatic(Listener.class, "outOfDescriptors", new Class[0], new int[0]);
                g.visitLabel(rethrow);
                this.base.visitVarInsn(25, ex);
                g.athrow();
                g.visitLabel(tail);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

