/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.file_leak_detector;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileDescriptor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.kohsuke.file_leak_detector.ActivityListener;

public class Listener {
    private static Map<Object, Record> TABLE = new WeakHashMap<Object, Record>();
    public static PrintWriter TRACE = null;
    public static PrintWriter ERROR = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset()));
    public static final List<String> EXCLUDES = new ArrayList<String>();
    private static boolean tracing = false;
    public static int THRESHOLD = 999999;
    static boolean AGENT_INSTALLED = false;
    private static final Field SOCKETIMPL_SOCKET = Listener.getSocketField("socket");
    private static final Field SOCKETIMPL_SERVER_SOCKET = Listener.getSocketField("serverSocket");

    public static boolean isAgentInstalled() {
        return AGENT_INSTALLED;
    }

    public static synchronized void makeStrong() {
        TABLE = new LinkedHashMap<Object, Record>(TABLE);
    }

    public static synchronized void open(Object _this, File f) {
        Listener.put(_this, new PathRecord(f.toPath()));
        for (ActivityListener al : ActivityListener.LIST) {
            al.open(_this, f);
        }
    }

    public static synchronized void open(Object _this, Path p) {
        Listener.put(_this, new PathRecord(p));
        for (ActivityListener al : ActivityListener.LIST) {
            al.open(_this, p);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path comes from sun.nio.fs.UnixChannelFactory.newFileChannel(int, sun.nio.fs.UnixPath, java.lang.String, java.util.Set<? extends java.nio.file.OpenOption>, int). At this point, the path is not controlled by the user.")
    public static synchronized void openFileString(Object _this, FileDescriptor fileDescriptor, String path) {
        Listener.open(_this, Paths.get(path, new String[0]));
    }

    public static synchronized void openPipe(Object _this) {
        if (_this instanceof Pipe.SourceChannel) {
            Listener.put(_this, new SourceChannelRecord((Pipe.SourceChannel)_this));
            for (ActivityListener al : ActivityListener.LIST) {
                al.fd_open(_this);
            }
        }
        if (_this instanceof Pipe.SinkChannel) {
            Listener.put(_this, new SinkChannelRecord((Pipe.SinkChannel)_this));
            for (ActivityListener al : ActivityListener.LIST) {
                al.fd_open(_this);
            }
        }
    }

    public static synchronized void openFileChannel(FileChannel fileChannel, Path path) {
        Listener.open((Object)fileChannel, path);
    }

    public static synchronized void openFileChannel(SeekableByteChannel byteChannel, Path path) {
        Listener.open((Object)byteChannel, path);
    }

    public static synchronized void openDirectoryStream(DirectoryStream<?> directoryStream, Path path) {
        Listener.open(directoryStream, path);
    }

    public static synchronized void openSelector(Object _this) {
        if (_this instanceof Selector) {
            Listener.put(_this, new SelectorRecord((Selector)_this));
            for (ActivityListener al : ActivityListener.LIST) {
                al.fd_open(_this);
            }
        }
    }

    public static synchronized void openSocket(Object _this) {
        if (_this instanceof SocketImpl) {
            try {
                ServerSocket ss;
                SocketImpl si = (SocketImpl)_this;
                Socket s = (Socket)SOCKETIMPL_SOCKET.get(si);
                if (s != null) {
                    Listener.put(_this, new SocketRecord(s));
                    for (ActivityListener al : ActivityListener.LIST) {
                        al.openSocket(s);
                    }
                }
                if ((ss = (ServerSocket)SOCKETIMPL_SERVER_SOCKET.get(si)) != null) {
                    Listener.put(_this, new ServerSocketRecord(ss));
                    for (ActivityListener al : ActivityListener.LIST) {
                        al.openSocket(ss);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (_this instanceof SocketChannel) {
            Listener.put(_this, new SocketChannelRecord((SocketChannel)_this));
            for (ActivityListener al : ActivityListener.LIST) {
                al.openSocket(_this);
            }
        }
    }

    public static synchronized List<Record> getCurrentOpenFiles() {
        return new ArrayList<Record>(TABLE.values());
    }

    private static synchronized void put(Object _this, Record r) {
        if (r.exclude()) {
            if (TRACE != null && !tracing) {
                tracing = true;
                r.dump("Excluded ", TRACE);
                tracing = false;
            }
            return;
        }
        TABLE.put(_this, r);
        if (TABLE.size() > THRESHOLD) {
            THRESHOLD = 999999;
            Listener.dump(ERROR);
        }
        if (TRACE != null && !tracing) {
            tracing = true;
            r.dump("Opened ", TRACE);
            tracing = false;
        }
    }

    public static synchronized void close(Object _this) {
        Record r = TABLE.remove(_this);
        if (r != null && TRACE != null && !tracing) {
            tracing = true;
            r.dump("Closed ", TRACE);
            tracing = false;
        }
        for (ActivityListener al : ActivityListener.LIST) {
            al.close(_this);
        }
    }

    public static synchronized void dump(OutputStream out) {
        Listener.dump(new OutputStreamWriter(out, Charset.defaultCharset()));
    }

    public static synchronized void dump(Writer w) {
        PrintWriter pw = new PrintWriter(w);
        Record[] records = TABLE.values().toArray(new Record[0]);
        pw.println(records.length + " descriptors are open");
        int i = 0;
        for (Record r : records) {
            r.dump("#" + ++i + " ", pw);
        }
        pw.println("----");
        pw.flush();
    }

    public static synchronized void outOfDescriptors() {
        if (ERROR != null && !tracing) {
            tracing = true;
            ERROR.println("Too many open files");
            Listener.dump(ERROR);
            tracing = false;
        }
    }

    private static String format(long time) {
        try {
            return new Date(time).toString();
        }
        catch (Exception e) {
            return Long.toString(time);
        }
    }

    private static Field getSocketField(String socket) {
        try {
            Field socketimplSocket = SocketImpl.class.getDeclaredField(socket);
            socketimplSocket.setAccessible(true);
            return socketimplSocket;
        }
        catch (NoSuchFieldException e) {
            System.err.println("Could not load field " + socket + " from SocketImpl: " + String.valueOf(e));
            return null;
        }
    }

    public static final class PathRecord
    extends Record {
        public final Path path;

        private PathRecord(Path path) {
            this.path = path;
        }

        @Override
        public void dump(String prefix, PrintWriter pw) {
            pw.println(prefix + String.valueOf(this.path) + " by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, pw);
        }

        public String toString() {
            return "PathRecord[file=" + String.valueOf(this.path) + "]";
        }
    }

    public static class Record {
        public final Exception stackTrace = new Exception();
        public final String threadName = Thread.currentThread().getName();
        public final long time = System.currentTimeMillis();

        protected Record() {
        }

        public void dump(String prefix, PrintWriter pw) {
            int i;
            StackTraceElement[] trace = this.stackTrace.getStackTrace();
            for (i = 0; i < trace.length; ++i) {
                if (!trace[i].getClassName().equals("java.lang.reflect.Method")) continue;
                ++i;
                break;
            }
            while (i < trace.length) {
                pw.println("\tat " + String.valueOf(trace[i]));
                ++i;
            }
            pw.flush();
        }

        public boolean exclude() {
            int i;
            if (EXCLUDES.isEmpty()) {
                return false;
            }
            StackTraceElement[] trace = this.stackTrace.getStackTrace();
            for (i = 0; i < trace.length; ++i) {
                if (!trace[i].getClassName().equals("java.lang.reflect.Method")) continue;
                ++i;
                break;
            }
            while (i < trace.length) {
                String t = trace[i].toString();
                for (String exclude : EXCLUDES) {
                    if (!t.contains(exclude)) continue;
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static final class SourceChannelRecord
    extends Record {
        public final Pipe.SourceChannel source;

        private SourceChannelRecord(Pipe.SourceChannel source) {
            this.source = source;
        }

        @Override
        public void dump(String prefix, PrintWriter pw) {
            pw.println(prefix + "Pipe Source Channel by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, pw);
        }
    }

    public static final class SinkChannelRecord
    extends Record {
        public final Pipe.SinkChannel sink;

        private SinkChannelRecord(Pipe.SinkChannel sink) {
            this.sink = sink;
        }

        @Override
        public void dump(String prefix, PrintWriter pw) {
            pw.println(prefix + "Pipe Sink Channel by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, pw);
        }
    }

    public static final class SelectorRecord
    extends Record {
        public final Selector selector;

        private SelectorRecord(Selector selector) {
            this.selector = selector;
        }

        @Override
        public void dump(String prefix, PrintWriter ps) {
            ps.println(prefix + "selector by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, ps);
        }
    }

    public static final class SocketRecord
    extends Record {
        public final Socket socket;
        public final String peer;

        private SocketRecord(Socket socket) {
            this.socket = socket;
            this.peer = this.getRemoteAddress(socket);
        }

        private String getRemoteAddress(Socket socket) {
            SocketAddress ra = socket.getRemoteSocketAddress();
            return ra != null ? ra.toString() : null;
        }

        @Override
        public void dump(String prefix, PrintWriter ps) {
            String peer = this.peer;
            if (peer == null) {
                peer = this.getRemoteAddress(this.socket);
            }
            ps.println(prefix + "socket to " + peer + " by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, ps);
        }

        public String toString() {
            return "SocketRecord[socket=" + String.valueOf(this.socket) + ",peer=" + this.peer + "]";
        }
    }

    public static final class ServerSocketRecord
    extends Record {
        public final ServerSocket socket;
        public final String address;

        private ServerSocketRecord(ServerSocket socket) {
            this.socket = socket;
            this.address = this.getLocalAddress(socket);
        }

        private String getLocalAddress(ServerSocket socket) {
            SocketAddress la = socket.getLocalSocketAddress();
            return la != null ? la.toString() : null;
        }

        @Override
        public void dump(String prefix, PrintWriter ps) {
            String address = this.address;
            if (address == null) {
                address = this.getLocalAddress(this.socket);
            }
            ps.println(prefix + "server socket at " + address + " by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, ps);
        }
    }

    public static final class SocketChannelRecord
    extends Record {
        public final SocketChannel socket;

        private SocketChannelRecord(SocketChannel socket) {
            this.socket = socket;
        }

        @Override
        public void dump(String prefix, PrintWriter ps) {
            ps.println(prefix + "socket channel by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, ps);
        }
    }

    public static final class FileRecord
    extends Record {
        public final File file;

        private FileRecord(File file) {
            this.file = file;
        }

        @Override
        public void dump(String prefix, PrintWriter pw) {
            pw.println(prefix + String.valueOf(this.file) + " by thread:" + this.threadName + " on " + Listener.format(this.time));
            super.dump(prefix, pw);
        }

        public String toString() {
            return "FileRecord[file=" + String.valueOf(this.file) + "]";
        }
    }
}

