/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;
import org.jvnet.hudson.tools.versionnumber.VersionNumberCommon;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VersionNumberStep
extends AbstractStepImpl {
    private static final Logger LOGGER = Logger.getLogger(MethodHandles.lookup().lookupClass().getCanonicalName());
    public final String versionNumberString;
    @DataBoundSetter
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public boolean skipFailedBuilds = false;
    @DataBoundSetter
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String worstResultForIncrement = null;
    @DataBoundSetter
    public String versionPrefix = null;
    @DataBoundSetter
    public String projectStartDate = null;
    @DataBoundSetter
    public String overrideBuildsAllTime = null;
    @DataBoundSetter
    public String overrideBuildsToday = null;
    @DataBoundSetter
    public String overrideBuildsThisWeek = null;
    @DataBoundSetter
    public String overrideBuildsThisMonth = null;
    @DataBoundSetter
    public String overrideBuildsThisYear = null;

    @DataBoundConstructor
    public VersionNumberStep(String versionNumberString) {
        if (versionNumberString == null || versionNumberString.isEmpty()) {
            throw new IllegalArgumentException("must specify a version number string.");
        }
        this.versionNumberString = versionNumberString;
    }

    public Date getProjectStartDate() {
        Date value = VersionNumberCommon.parseDate(this.projectStartDate);
        if (value.compareTo(new Date(0L)) != 0) {
            return value;
        }
        return null;
    }

    public String getVersionPrefix() {
        if (this.versionPrefix != null && !this.versionPrefix.isEmpty()) {
            return this.versionPrefix;
        }
        return null;
    }

    public Result getWorstResultForIncrement() {
        if (this.skipFailedBuilds) {
            LOGGER.warning("At least in one project VersionNumber plugin still uses the old config-variable 'skipFailedBuilds'. Make sure to update and safe the job-configs to update that behavior.");
            this.skipFailedBuilds = false;
            this.worstResultForIncrement = "SUCCESS";
        }
        if (this.worstResultForIncrement == null) {
            this.worstResultForIncrement = "NOT_BUILT";
        }
        switch (this.worstResultForIncrement) {
            case "NOT_BUILT": {
                return Result.NOT_BUILT;
            }
            case "ABORTED": {
                return Result.ABORTED;
            }
            case "FAILURE": {
                return Result.FAILURE;
            }
            case "UNSTABLE": {
                return Result.UNSTABLE;
            }
            case "SUCCESS": {
                return Result.SUCCESS;
            }
        }
        this.worstResultForIncrement = "SUCCESS";
        return Result.SUCCESS;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<String> {
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient EnvVars env;
        @Inject(optional=true)
        private transient VersionNumberStep step;
        private static final long serialVersionUID = 2L;

        protected String run() throws Exception {
            if (this.step.versionNumberString != null) {
                try {
                    Run prevBuild = VersionNumberCommon.getPreviousBuildWithVersionNumber(this.run, this.step.versionPrefix);
                    VersionNumberBuildInfo info = VersionNumberCommon.incBuild(this.run, this.env, prevBuild, this.step.getWorstResultForIncrement(), this.step.overrideBuildsToday, this.step.overrideBuildsThisWeek, this.step.overrideBuildsThisMonth, this.step.overrideBuildsThisYear, this.step.overrideBuildsAllTime);
                    Object formattedVersionNumber = VersionNumberCommon.formatVersionNumber(this.step.versionNumberString, this.step.getProjectStartDate(), info, (Map<String, String>)this.env, this.run.getTimestamp());
                    if (this.step.versionPrefix != null) {
                        formattedVersionNumber = this.step.versionPrefix + (String)formattedVersionNumber;
                    }
                    this.run.addAction((Action)new VersionNumberAction(info, (String)formattedVersionNumber));
                    return formattedVersionNumber;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "VersionNumber";
        }

        public String getDisplayName() {
            return "Determine the correct version number";
        }

        public ListBoxModel doFillWorstResultForIncrementItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SUCCESS");
            items.add("UNSTABLE");
            items.add("FAILURE");
            items.add("ABORTED");
            items.add("NOT_BUILT");
            return items;
        }
    }
}

