/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import hudson.EnvVars;
import hudson.model.Result;
import hudson.model.Run;
import java.lang.invoke.MethodHandles;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.jvnet.hudson.tools.versionnumber.BuildsAllTimeGenerator;
import org.jvnet.hudson.tools.versionnumber.BuildsThisMonthGenerator;
import org.jvnet.hudson.tools.versionnumber.BuildsThisWeekGenerator;
import org.jvnet.hudson.tools.versionnumber.BuildsThisYearGenerator;
import org.jvnet.hudson.tools.versionnumber.BuildsTodayGenerator;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;

public class VersionNumberCommon {
    private static final Logger LOGGER = Logger.getLogger(MethodHandles.lookup().lookupClass().getCanonicalName());
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String WORST_RESULT_SUCCESS = "SUCCESS";
    public static final String WORST_RESULT_UNSTABLE = "UNSTABLE";
    public static final String WORST_RESULT_FAILURE = "FAILURE";
    public static final String WORST_RESULT_ABORTED = "ABORTED";
    public static final String WORST_RESULT_NOT_BUILT = "NOT_BUILT";
    public static final String ENV_VAR_PATTERN = "^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$";

    public static VersionNumberBuildInfo incBuild(Run build, EnvVars vars, Run prevBuild, Result worstResultForIncrement, String overrideBuildsToday, String overrideBuildsThisWeek, String overrideBuildsThisMonth, String overrideBuildsThisYear, String overrideBuildsAllTime) {
        int buildsToday = new BuildsTodayGenerator().getNextNumber(build, vars, prevBuild, worstResultForIncrement, overrideBuildsToday);
        int buildsThisWeek = new BuildsThisWeekGenerator().getNextNumber(build, vars, prevBuild, worstResultForIncrement, overrideBuildsThisWeek);
        int buildsThisMonth = new BuildsThisMonthGenerator().getNextNumber(build, vars, prevBuild, worstResultForIncrement, overrideBuildsThisMonth);
        int buildsThisYear = new BuildsThisYearGenerator().getNextNumber(build, vars, prevBuild, worstResultForIncrement, overrideBuildsThisYear);
        int buildsAllTime = new BuildsAllTimeGenerator().getNextNumber(build, vars, prevBuild, worstResultForIncrement, overrideBuildsAllTime);
        return new VersionNumberBuildInfo(buildsToday, buildsThisWeek, buildsThisMonth, buildsThisYear, buildsAllTime);
    }

    public static Run getPreviousBuildWithVersionNumber(Run build, String envPrefix) {
        for (Run prevBuild = build.getPreviousBuild(); prevBuild != null; prevBuild = prevBuild.getPreviousBuild()) {
            VersionNumberAction prevAction = (VersionNumberAction)prevBuild.getAction(VersionNumberAction.class);
            if (prevAction == null) {
                LOGGER.fine("prevAction.getVersionNumber() : 'null'");
            } else {
                LOGGER.fine("prevAction.getVersionNumber() : '" + prevAction.getVersionNumber() + "'");
            }
            if (prevAction == null) continue;
            if (envPrefix != null) {
                String version = prevAction.getVersionNumber();
                if (!version.startsWith(envPrefix)) continue;
                LOGGER.info("Previous build's version-number: '" + prevAction.getVersionNumber() + "'");
                return prevBuild;
            }
            LOGGER.info("Previous build's version-number: '" + prevAction.getVersionNumber() + "'");
            return prevBuild;
        }
        LOGGER.info("Previous build's version-number: N/A");
        return null;
    }

    public static Date parseDate(String dateString) {
        try {
            SimpleDateFormat defaultDateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT_PATTERN);
            return defaultDateFormat.parse(dateString);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    public static String formatVersionNumber(String versionNumberFormatString, Date projectStartDate, VersionNumberBuildInfo info, Map<String, String> enVars, Calendar buildDate) {
        LOGGER.info("Version-number format-string before expansion of env-variables: '" + versionNumberFormatString + "'");
        Object vnf = new EnvVars(enVars).expand(versionNumberFormatString);
        LOGGER.info("Version-number format-string after expansion of env-variables: '" + (String)vnf + "'");
        int blockStart = 0;
        do {
            if ((blockStart = ((String)vnf).indexOf("${")) < 0) continue;
            int blockEnd = ((String)vnf).indexOf("}", blockStart) + 1;
            if (blockEnd <= blockStart) {
                vnf = ((String)vnf).substring(0, blockStart);
                break;
            }
            int commandStart = blockStart + 2;
            int commandEnd = blockEnd - 1;
            int argumentStart = ((String)vnf).indexOf(",", blockStart);
            int argumentEnd = 0;
            if (argumentStart > 0 && argumentStart < blockEnd) {
                argumentEnd = blockEnd - 1;
                commandEnd = argumentStart;
            }
            String expressionKey = ((String)vnf).substring(commandStart, commandEnd);
            String argumentString = argumentEnd > 0 ? ((String)vnf).substring(argumentStart + 1, argumentEnd).trim() : "";
            String replaceValue = "";
            if ("".equals(expressionKey)) {
                replaceValue = "";
            } else if ("BUILD_DATE_FORMATTED".equals(expressionKey)) {
                DateFormat fmt = SimpleDateFormat.getInstance();
                if (!"".equals(argumentString)) {
                    String fmtString = argumentString.substring(argumentString.indexOf(34) + 1, argumentString.indexOf(34, argumentString.indexOf(34) + 1));
                    fmt = new SimpleDateFormat(fmtString);
                }
                replaceValue = fmt.format(buildDate.getTime());
            } else if ("BUILD_DAY".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(buildDate.get(5)), argumentString.length());
            } else if ("BUILD_WEEK".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(buildDate.get(3)), argumentString.length());
            } else if ("BUILD_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(buildDate.get(2) + 1), argumentString.length());
            } else if ("BUILD_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(buildDate.get(1)), argumentString.length());
            } else if ("BUILDS_TODAY".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsToday()), argumentString.length());
            } else if ("BUILDS_THIS_WEEK".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsThisWeek()), argumentString.length());
            } else if ("BUILDS_THIS_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsThisMonth()), argumentString.length());
            } else if ("BUILDS_THIS_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsThisYear()), argumentString.length());
            } else if ("BUILDS_ALL_TIME".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsAllTime()), argumentString.length());
            } else if ("BUILDS_TODAY_Z".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsToday() - 1), argumentString.length());
            } else if ("BUILDS_THIS_MONTH_Z".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsThisMonth() - 1), argumentString.length());
            } else if ("BUILDS_THIS_YEAR_Z".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsThisYear() - 1), argumentString.length());
            } else if ("BUILDS_ALL_TIME_Z".equals(expressionKey)) {
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(info.getBuildsAllTime() - 1), argumentString.length());
            } else if ("MONTHS_SINCE_PROJECT_START".equals(expressionKey) && projectStartDate != null) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int monthsSinceStart = buildDate.get(2) - projectStartCal.get(2);
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(monthsSinceStart += (buildDate.get(1) - projectStartCal.get(1)) * 12), argumentString.length());
            } else if ("YEARS_SINCE_PROJECT_START".equals(expressionKey) && projectStartDate != null) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int yearsSinceStart = buildDate.get(1) - projectStartCal.get(1);
                replaceValue = VersionNumberCommon.sizeTo(Integer.toString(yearsSinceStart), argumentString.length());
            } else {
                LOGGER.fine("Special case: A variable could not be resolved. (Does it resolve to itself?) [var == " + expressionKey + "]");
                for (Map.Entry<String, String> entry : enVars.entrySet()) {
                    if (!entry.getKey().equals(expressionKey)) continue;
                    if (entry.getValue().equals("${" + expressionKey + "}")) {
                        LOGGER.fine("Yes, the variable resolves to itself. Ignoring it. [var == " + expressionKey + "]");
                        continue;
                    }
                    LOGGER.fine("No, the variable does not resolve to itself. Using it. [var == " + expressionKey + "]");
                    replaceValue = entry.getValue();
                    replaceValue = VersionNumberCommon.selectSubstringOfReplaceValue(replaceValue, argumentString);
                }
            }
            vnf = ((String)vnf).substring(0, blockStart) + replaceValue + ((String)vnf).substring(blockEnd, ((String)vnf).length());
        } while (blockStart >= 0);
        LOGGER.info("Version-number format-string after expansion of all variables: '" + (String)vnf + "'");
        return vnf;
    }

    private static String selectSubstringOfReplaceValue(String replaceValue, String argumentString) {
        Integer fmtInt;
        String fmtString;
        LOGGER.info("Before selecting a substring of the replace-value. [replaceValue == " + replaceValue + ", argumentString == " + argumentString + "]");
        if (!"".equals(argumentString) && argumentString.length() >= 3 && argumentString.charAt(0) == '\"' && argumentString.charAt(argumentString.length() - 1) == '\"' && (fmtString = argumentString.substring(1, argumentString.length() - 1)).matches("^(\\+|-)?\\d+$") && Math.abs(fmtInt = Integer.valueOf(Integer.parseInt(fmtString))) < replaceValue.length()) {
            if (fmtInt > 0) {
                replaceValue = replaceValue.substring(0, fmtInt);
            } else if (fmtInt < 0) {
                replaceValue = replaceValue.substring(replaceValue.length() + fmtInt);
            }
        }
        LOGGER.info("After selecting a substring of the replace-value. [replaceValue == " + replaceValue + "]");
        return replaceValue;
    }

    public static String makeValid(String value) {
        if (value == null) {
            return "";
        }
        try {
            value = value.trim();
            Integer intVal = Integer.valueOf(value);
            if (intVal < 0) {
                return "";
            }
            return intVal.toString();
        }
        catch (Exception e) {
            if (value.matches(ENV_VAR_PATTERN)) {
                return value;
            }
            return "";
        }
    }

    private static String sizeTo(String s, int length) {
        while (((String)s).length() < length) {
            s = "0" + (String)s;
        }
        return s;
    }
}

