/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;
import org.jvnet.hudson.tools.versionnumber.VersionNumberCommon;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class VersionNumberBuilder
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(MethodHandles.lookup().lookupClass().getCanonicalName());
    private final String versionNumberString;
    private final Date projectStartDate;
    private final String environmentVariableName;
    private final String environmentPrefixVariable;
    private String oBuildsToday;
    private String oBuildsThisWeek;
    private String oBuildsThisMonth;
    private String oBuildsThisYear;
    private String oBuildsAllTime;
    private String worstResultForIncrement = null;
    @Deprecated
    private boolean skipFailedBuilds = false;
    private boolean useAsBuildDisplayName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public VersionNumberBuilder(String versionNumberString, String projectStartDate, String environmentVariableName, String environmentPrefixVariable, String buildsToday, String buildsThisWeek, String buildsThisMonth, String buildsThisYear, String buildsAllTime, boolean skipFailedBuilds) {
        this(versionNumberString, projectStartDate, environmentVariableName, environmentPrefixVariable, buildsToday, buildsThisWeek, buildsThisMonth, buildsThisYear, buildsAllTime, skipFailedBuilds ? "SUCCESS" : "NOT_BUILT", false);
    }

    public VersionNumberBuilder(String versionNumberString, String projectStartDate, String environmentVariableName, String environmentPrefixVariable, String buildsToday, String buildsThisWeek, String buildsThisMonth, String buildsThisYear, String buildsAllTime, boolean skipFailedBuilds, boolean useAsBuildDisplayName) {
        this(versionNumberString, projectStartDate, environmentVariableName, environmentPrefixVariable, buildsToday, buildsThisWeek, buildsThisMonth, buildsThisYear, buildsAllTime, skipFailedBuilds ? "SUCCESS" : "NOT_BUILT", useAsBuildDisplayName);
    }

    @DataBoundConstructor
    public VersionNumberBuilder(String versionNumberString, String projectStartDate, String environmentVariableName, String environmentPrefixVariable, String buildsToday, String buildsThisWeek, String buildsThisMonth, String buildsThisYear, String buildsAllTime, String worstResultForIncrement, boolean useAsBuildDisplayName) {
        this.versionNumberString = versionNumberString;
        this.projectStartDate = VersionNumberCommon.parseDate(projectStartDate);
        this.environmentVariableName = environmentVariableName;
        this.environmentPrefixVariable = environmentPrefixVariable;
        this.worstResultForIncrement = worstResultForIncrement;
        this.useAsBuildDisplayName = useAsBuildDisplayName;
        this.oBuildsToday = VersionNumberCommon.makeValid(buildsToday);
        this.oBuildsThisWeek = VersionNumberCommon.makeValid(buildsThisWeek);
        this.oBuildsThisMonth = VersionNumberCommon.makeValid(buildsThisMonth);
        this.oBuildsThisYear = VersionNumberCommon.makeValid(buildsThisYear);
        this.oBuildsAllTime = VersionNumberCommon.makeValid(buildsAllTime);
    }

    public String getBuildsToday() {
        return this.oBuildsToday;
    }

    public String getBuildsThisWeek() {
        return this.oBuildsThisWeek;
    }

    public String getBuildsThisMonth() {
        return this.oBuildsThisMonth;
    }

    public String getBuildsThisYear() {
        return this.oBuildsThisYear;
    }

    public String getBuildsAllTime() {
        return this.oBuildsAllTime;
    }

    public Result getWorstResultForIncrement() {
        if (this.skipFailedBuilds) {
            LOGGER.warning("At least in one project VersionNumber plugin still uses the old config-variable 'skipFailedBuilds'. Make sure to update and safe the job-configs to update that behavior.");
            this.skipFailedBuilds = false;
            this.worstResultForIncrement = "SUCCESS";
        }
        if (this.worstResultForIncrement == null) {
            this.worstResultForIncrement = "NOT_BUILT";
        }
        switch (this.worstResultForIncrement) {
            case "NOT_BUILT": {
                return Result.NOT_BUILT;
            }
            case "ABORTED": {
                return Result.ABORTED;
            }
            case "FAILURE": {
                return Result.FAILURE;
            }
            case "UNSTABLE": {
                return Result.UNSTABLE;
            }
            case "SUCCESS": {
                return Result.SUCCESS;
            }
        }
        this.worstResultForIncrement = "SUCCESS";
        return Result.SUCCESS;
    }

    public boolean getUseAsBuildDisplayName() {
        return this.useAsBuildDisplayName;
    }

    public String getVersionNumberString() {
        return this.versionNumberString;
    }

    public String getProjectStartDate() {
        SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return defaultDateFormat.format(this.projectStartDate);
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    public String getEnvironmentPrefixVariable() {
        return this.environmentPrefixVariable;
    }

    private Run getPreviousBuildWithVersionNumber(Run build, BuildListener listener) {
        String envPrefix;
        if (this.environmentPrefixVariable != null) {
            try {
                EnvVars env = build.getEnvironment((TaskListener)listener);
                envPrefix = (String)env.get((Object)this.environmentPrefixVariable);
            }
            catch (IOException e) {
                envPrefix = null;
            }
            catch (InterruptedException e) {
                envPrefix = null;
            }
        } else {
            envPrefix = null;
        }
        return VersionNumberCommon.getPreviousBuildWithVersionNumber(build, envPrefix);
    }

    private VersionNumberBuildInfo incBuild(Run build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars enVars = build.getEnvironment((TaskListener)listener);
        Run prevBuild = this.getPreviousBuildWithVersionNumber(build, listener);
        VersionNumberBuildInfo incBuildInfo = VersionNumberCommon.incBuild(build, enVars, prevBuild, this.getWorstResultForIncrement(), this.oBuildsToday, this.oBuildsThisWeek, this.oBuildsThisMonth, this.oBuildsThisYear, this.oBuildsAllTime);
        boolean saveOverrides = false;
        if (this.oBuildsToday == null || !this.oBuildsToday.equals("")) {
            saveOverrides = true;
            this.oBuildsToday = VersionNumberCommon.makeValid(this.oBuildsToday);
            try {
                if (!this.oBuildsToday.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                    this.oBuildsToday = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.oBuildsThisWeek == null || !this.oBuildsThisWeek.equals("")) {
            saveOverrides = true;
            this.oBuildsThisWeek = VersionNumberCommon.makeValid(this.oBuildsThisWeek);
            try {
                if (!this.oBuildsThisWeek.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                    this.oBuildsThisWeek = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.oBuildsThisMonth == null || !this.oBuildsThisMonth.equals("")) {
            saveOverrides = true;
            this.oBuildsThisMonth = VersionNumberCommon.makeValid(this.oBuildsThisMonth);
            try {
                if (!this.oBuildsThisMonth.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                    this.oBuildsThisMonth = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.oBuildsThisYear == null || !this.oBuildsThisYear.equals("")) {
            saveOverrides = true;
            this.oBuildsThisYear = VersionNumberCommon.makeValid(this.oBuildsThisYear);
            try {
                if (!this.oBuildsThisYear.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                    this.oBuildsThisYear = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.oBuildsAllTime == null || !this.oBuildsAllTime.equals("")) {
            saveOverrides = true;
            this.oBuildsAllTime = VersionNumberCommon.makeValid(this.oBuildsAllTime);
            try {
                if (!this.oBuildsAllTime.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                    this.oBuildsAllTime = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (saveOverrides) {
            build.getParent().save();
        }
        return incBuildInfo;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String formattedVersionNumber = "";
        try {
            VersionNumberBuildInfo info = this.incBuild((Run)build, listener);
            formattedVersionNumber = VersionNumberCommon.formatVersionNumber(this.versionNumberString, this.projectStartDate, info, (Map<String, String>)build.getEnvironment((TaskListener)listener), build.getTimestamp());
            build.addAction((Action)new VersionNumberAction(info, formattedVersionNumber));
            if (this.useAsBuildDisplayName) {
                build.setDisplayName(formattedVersionNumber);
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(e.toString()));
            build.setResult(Result.FAILURE);
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error(e.toString()));
            build.setResult(Result.FAILURE);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error(e.toString()));
            build.setResult(Result.FAILURE);
        }
        final String finalVersionNumber = formattedVersionNumber;
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put(VersionNumberBuilder.this.environmentVariableName, finalVersionNumber);
            }
        };
    }

    public BuildWrapperDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(VersionNumberBuilder.class);
            this.load();
        }

        public FormValidation doCheckEnvironmentVariableName(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an environment variable name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionNumberString(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a version number format string.  For more information, click on the ?.");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectStartDate(@QueryParameter String value) {
            if (value.length() > 0 && VersionNumberCommon.parseDate(value).compareTo(new Date(0L)) == 0) {
                return FormValidation.error((String)"Valid dates are in the format yyyy-mm-dd");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillWorstResultForIncrementItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SUCCESS");
            items.add("UNSTABLE");
            items.add("FAILURE");
            items.add("ABORTED");
            items.add("NOT_BUILT");
            return items;
        }

        public String getDisplayName() {
            return "Create a formatted version number";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            return super.configure(req, json);
        }

        public boolean isApplicable(AbstractProject<?, ?> proj) {
            return true;
        }
    }
}

