/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import hudson.EnvVars;
import hudson.model.Result;
import hudson.model.Run;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hudson.tools.versionnumber.BuildNumberGenerator;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;
import org.jvnet.hudson.tools.versionnumber.VersionNumberCommon;

public abstract class AbstractBuildNumberGenerator
implements BuildNumberGenerator {
    @Override
    public int getNextNumber(Run build, EnvVars vars, Run prevBuild, Result worstResultForIncrement, String override) {
        int nextNumber = 1;
        if (override != null && AbstractBuildNumberGenerator.isValidOverride(vars, override)) {
            nextNumber = AbstractBuildNumberGenerator.resolveOverride(vars, override);
        } else if (prevBuild != null) {
            int increment = 1;
            Result result = prevBuild.getResult();
            if (result != null && result.isWorseThan(worstResultForIncrement)) {
                increment = 0;
            }
            nextNumber = this.resolveValue(build, prevBuild, increment);
        }
        return nextNumber;
    }

    protected VersionNumberBuildInfo getPreviousBuildInfo(Run prevBuild) {
        VersionNumberAction prevAction = (VersionNumberAction)prevBuild.getAction(VersionNumberAction.class);
        VersionNumberBuildInfo info = prevAction.getInfo();
        return info;
    }

    public static boolean isValidOverride(EnvVars envVars, String override) {
        return AbstractBuildNumberGenerator.resolveOverride(envVars, override) != null;
    }

    public static Integer resolveOverride(EnvVars envVars, String override) {
        Integer result = null;
        Pattern pattern = Pattern.compile("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$");
        override = VersionNumberCommon.makeValid(override);
        try {
            if (!override.matches("^(?:\\$\\{(\\w+)\\})|(?:\\$(\\w+))$")) {
                result = Integer.parseInt(override);
                override = "";
            } else {
                Matcher m = pattern.matcher(override);
                if (m.matches()) {
                    String varName = m.group(1) != null ? m.group(1) : m.group(2);
                    result = Integer.parseInt((String)envVars.get((Object)varName));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null || result < 0) {
            result = null;
        }
        return result;
    }
}

