/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;

public class PluginList
implements Comparable<PluginList> {
    private Map<String, String> plugins;
    private final File pluginsXml;

    public PluginList(File pluginsXml) {
        this.pluginsXml = pluginsXml;
        this.plugins = new HashMap<String, String>();
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public void add(String name, String version) {
        this.plugins.put(name, version);
    }

    public void setPlugins(Map<String, String> plugins) {
        this.plugins = plugins;
    }

    public void save() throws IOException {
        new XmlFile(Jenkins.XSTREAM, this.pluginsXml).write((Object)this);
    }

    public void load() throws IOException {
        XmlFile xmlFile = new XmlFile(Jenkins.XSTREAM, this.pluginsXml);
        if (xmlFile.exists()) {
            xmlFile.unmarshal((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginList that = (PluginList)o;
        return Objects.equals(this.plugins, that.plugins);
    }

    public int hashCode() {
        return Objects.hash(this.plugins);
    }

    @Override
    public int compareTo(@NonNull PluginList other) {
        if (other == null) {
            return -1;
        }
        Map<String, String> plugins2 = other.getPlugins();
        if (plugins2.size() != this.plugins.size()) {
            return -1;
        }
        for (Map.Entry<String, String> entry : this.plugins.entrySet()) {
            String plugin = entry.getKey();
            String version = entry.getValue();
            String prevVersion = plugins2.get(plugin);
            if (version != null && !version.isEmpty() && prevVersion != null && !prevVersion.isEmpty() && version.equals(prevVersion)) continue;
            return -1;
        }
        return 0;
    }
}

