/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.scheduler.CronTab;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPluginImpl;
import org.jvnet.hudson.plugins.thinbackup.backup.HudsonBackup;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

@Extension
public class ThinBackupPeriodicWork
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private final ThinBackupPluginImpl plugin = ThinBackupPluginImpl.get();

    public ThinBackupPeriodicWork() {
        super("ThinBackup Worker Thread");
    }

    public long getRecurrencePeriod() {
        return 60000L;
    }

    protected void execute(TaskListener arg0) {
        String diffCron;
        String fullCron;
        long currentTime = System.currentTimeMillis();
        BackupType type = ThinBackupPeriodicWork.getNextScheduledBackupType(currentTime, fullCron = this.plugin.getFullBackupSchedule(), diffCron = this.plugin.getDiffBackupSchedule());
        if (type != BackupType.NONE) {
            this.backupNow(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backupNow(BackupType type) {
        Jenkins jenkins = Jenkins.get();
        boolean inQuietModeBeforeBackup = jenkins.isQuietingDown();
        String backupPath = null;
        try {
            backupPath = this.plugin.getExpandedBackupPath();
            if (backupPath != null && !backupPath.isEmpty()) {
                if (this.plugin.isWaitForIdle()) {
                    LOGGER.fine("Wait until executors are idle to perform backup.");
                    Utils.waitUntilIdleAndSwitchToQuietMode(this.plugin.getForceQuietModeTimeout(), TimeUnit.MINUTES);
                } else {
                    LOGGER.warning("Do not wait until Jenkins is idle to perform backup. This could cause corrupt backups.");
                }
                new HudsonBackup(this.plugin, type).backup();
                LOGGER.info("Backup process finished successfully.");
            } else {
                LOGGER.warning("ThinBackup is not configured yet: No backup path set.");
            }
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Cannot perform a backup. Please be sure Jenkins has write privileges in the configured backup path ''{0}''.", backupPath);
            LOGGER.log(Level.SEVERE, msg, e);
        }
        finally {
            if (!inQuietModeBeforeBackup) {
                jenkins.doCancelQuietDown();
            } else {
                LOGGER.warning("Still in quiet mode as before. The quiet mode needs to be canceled manually, because it is not clear who is putting Jenkins into quiet mode.");
            }
        }
    }

    static BackupType getNextScheduledBackupType(long currentTime, String fullCron, String diffCron) {
        long delay;
        long fullDelay = ThinBackupPeriodicWork.calculateDelay(currentTime, BackupType.FULL, fullCron);
        long diffDelay = ThinBackupPeriodicWork.calculateDelay(currentTime, BackupType.DIFF, diffCron);
        BackupType res = null;
        if (fullDelay == -1L && diffDelay == -1L) {
            return BackupType.NONE;
        }
        if (fullDelay != -1L && diffDelay == -1L) {
            res = BackupType.FULL;
            delay = fullDelay;
        } else if (fullDelay == -1L && diffDelay != -1L) {
            res = BackupType.DIFF;
            delay = diffDelay;
        } else {
            res = BackupType.DIFF;
            delay = diffDelay;
            if (fullDelay <= diffDelay) {
                delay = fullDelay;
                res = BackupType.FULL;
            }
        }
        return delay < 60000L ? res : BackupType.NONE;
    }

    static long calculateDelay(long currentTime, BackupType backupType, String cron) {
        try {
            if (cron == null || cron.isEmpty()) {
                return -1L;
            }
            CronTab cronTab = new CronTab(cron);
            Calendar nextExecution = cronTab.ceil(currentTime);
            long delay = nextExecution.getTimeInMillis() - currentTime;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Current time: {0,date,medium} {0,time,long}. Next execution ({3}) in {2} seconds which is {1,date,medium} {1,time,long}", new Object[]{new Date(currentTime), nextExecution.getTime(), TimeUnit.MILLISECONDS.toSeconds(delay), backupType}));
            }
            if (delay < 0L) {
                String msg = "Delay is a negative number, which means the next execution is in the past! This happens for Hudson/Jenkins installations with version 1.395 or below. Please upgrade to fix this.";
                LOGGER.severe("Delay is a negative number, which means the next execution is in the past! This happens for Hudson/Jenkins installations with version 1.395 or below. Please upgrade to fix this.");
                throw new IllegalStateException("Delay is a negative number, which means the next execution is in the past! This happens for Hudson/Jenkins installations with version 1.395 or below. Please upgrade to fix this.");
            }
            return delay;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning(MessageFormat.format("Cannot parse the specified ''Backup schedule for {0} backups''. Check cron notation.", new Object[]{backupType}));
            return -1L;
        }
    }

    public static enum BackupType {
        NONE,
        FULL,
        DIFF;

    }
}

