/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.restore;

import hudson.PluginManager;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.backup.BackupSet;
import org.jvnet.hudson.plugins.thinbackup.backup.PluginList;
import org.jvnet.hudson.plugins.thinbackup.restore.PluginRestoreUpdateCenter;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

public class HudsonRestore {
    private static final int SLEEP_TIMEOUT = 500;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private final String backupPath;
    private final File hudsonHome;
    private final Date restoreFromDate;
    private final boolean restoreNextBuildNumber;
    private final boolean restorePlugins;
    private final Map<String, List<UpdateSite.Plugin>> availablePluginLocations;

    public HudsonRestore(File hudsonConfigurationPath, String backupPath, Date restoreFromDate, boolean restoreNextBuildNumber, boolean restorePlugins) {
        this.hudsonHome = hudsonConfigurationPath;
        this.backupPath = backupPath;
        this.restoreFromDate = restoreFromDate;
        this.restoreNextBuildNumber = restoreNextBuildNumber;
        this.restorePlugins = restorePlugins;
        this.availablePluginLocations = new HashMap<String, List<UpdateSite.Plugin>>();
    }

    public void restore() {
        if (this.backupPath == null || this.backupPath.isEmpty()) {
            LOGGER.severe("Backup path not specified for restoration. Aborting.");
            return;
        }
        if (this.restoreFromDate == null) {
            LOGGER.severe("Backup date to restore from was not specified. Aborting.");
            return;
        }
        try {
            boolean success = this.restoreFromDirectories(this.backupPath);
            if (!success) {
                success = this.restoreFromZipFile();
            }
            if (!success) {
                LOGGER.severe("Could not restore backup.");
            } else {
                LOGGER.info("Restore completed successfully.");
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Could not restore backup.", ioe);
        }
    }

    private boolean restoreFromDirectories(String parentDirectory) throws IOException {
        boolean success = false;
        IOFileFilter suffixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)new SimpleDateFormat("yyyy-MM-dd_HH-mm").format(this.restoreFromDate)), DirectoryFileFilter.DIRECTORY});
        File[] candidates = new File(parentDirectory).listFiles((FileFilter)suffixFilter);
        if (candidates == null) {
            return false;
        }
        if (candidates.length > 1) {
            LOGGER.severe(String.format("More than one backup with date '%s' found. This is not allowed. Aborting restore.", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(this.restoreFromDate)));
        } else if (candidates.length == 1) {
            File toRestore = candidates[0];
            if (toRestore.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
                File referencedFullBackup = Utils.getReferencedFullBackup(toRestore);
                this.restore(referencedFullBackup);
            }
            this.restore(toRestore);
            success = true;
        } else {
            LOGGER.info(String.format("No backup directories with date '%s' found. Will try to find a backup in ZIP files next...", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(this.restoreFromDate)));
        }
        return success;
    }

    private boolean restoreFromZipFile() throws IOException {
        boolean success = false;
        IOFileFilter zippedBackupSetsFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"BACKUPSET"), FileFilterUtils.suffixFileFilter((String)".zip"), FileFileFilter.INSTANCE});
        File[] candidates = new File(this.backupPath).listFiles((FileFilter)zippedBackupSetsFilter);
        if (candidates != null) {
            for (File candidate : candidates) {
                BackupSet backupSet = new BackupSet(candidate);
                if (!backupSet.isValid() || !backupSet.containsBackupForDate(this.restoreFromDate)) continue;
                BackupSet unzippedBackup = backupSet.unzip();
                if (unzippedBackup.isValid()) {
                    success = this.restoreFromDirectories(backupSet.getUnzipDir().getAbsolutePath());
                }
                backupSet.deleteUnzipDir();
            }
        }
        return success;
    }

    private void restore(File toRestore) throws IOException {
        IOFileFilter restoreNextBuildNumberFilter;
        IOFileFilter nextBuildNumberFileFilter = FileFilterUtils.nameFileFilter((String)"nextBuildNumber");
        IOFileFilter noBackupCompletedFile = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"backup-completed.info"));
        if (this.restoreNextBuildNumber) {
            restoreNextBuildNumberFilter = noBackupCompletedFile;
            Collection restore = FileUtils.listFiles((File)toRestore, (IOFileFilter)nextBuildNumberFileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            HashMap<String, Integer> nextBuildNumbers = new HashMap<String, Integer>();
            for (File file : restore) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
                    nextBuildNumbers.put(file.getParentFile().getName(), Integer.parseInt(reader.readLine()));
                }
            }
            Collection current = FileUtils.listFiles((File)this.hudsonHome, (IOFileFilter)nextBuildNumberFileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : current) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
                    Integer toRestoreNextBuildNumber;
                    int currentBuildNumber = Integer.parseInt(reader.readLine());
                    if (currentBuildNumber >= (toRestoreNextBuildNumber = (Integer)nextBuildNumbers.get(file.getParentFile().getName()))) continue;
                    this.restoreNextBuildNumber(file, toRestoreNextBuildNumber);
                }
            }
        } else {
            restoreNextBuildNumberFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)nextBuildNumberFileFilter), noBackupCompletedFile});
        }
        FileUtils.copyDirectory((File)toRestore, (File)this.hudsonHome, (FileFilter)restoreNextBuildNumberFilter, (boolean)true);
        if (this.restorePlugins) {
            this.restorePlugins(toRestore);
        }
    }

    private void restorePlugins(File toRestore) throws IOException {
        File[] list = toRestore.listFiles((FilenameFilter)FileFilterUtils.nameFileFilter((String)"installedPlugins.xml"));
        if (list == null) {
            LOGGER.severe("Cannot restore plugins because null is returned for files to restore.");
            return;
        }
        if (list.length != 1) {
            LOGGER.severe("Cannot restore plugins because no or multiple files with the name 'installedPlugins.xml' are in the backup.");
            return;
        }
        if (list[0] == null) {
            LOGGER.severe("Cannot restore plugins because backuped plugin is null.");
            return;
        }
        File backupedPlugins = list[0];
        PluginList pluginList = new PluginList(backupedPlugins);
        pluginList.load();
        Map<String, String> toRestorePlugins = pluginList.getPlugins();
        ArrayList<Future<UpdateCenter.UpdateCenterJob>> pluginRestoreJobs = new ArrayList<Future<UpdateCenter.UpdateCenterJob>>(toRestorePlugins.size());
        Jenkins jenkins = Jenkins.get();
        PluginManager pluginManager = jenkins.getPluginManager();
        for (Map.Entry<String, String> entry : toRestorePlugins.entrySet()) {
            if (pluginManager.getPlugin(entry.getKey()) == null) {
                Future<UpdateCenter.UpdateCenterJob> monitor = this.installPlugin(entry.getKey(), entry.getValue());
                if (monitor == null) continue;
                pluginRestoreJobs.add(monitor);
                continue;
            }
            LOGGER.info("Plugin '" + entry.getKey() + "' already installed. Please check manually.");
        }
        boolean finished = pluginRestoreJobs.isEmpty();
        while (!finished) {
            Future future;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted!", e);
                Thread.currentThread().interrupt();
            }
            Iterator iterator = pluginRestoreJobs.iterator();
            while (iterator.hasNext() && (finished = (future = (Future)iterator.next()).isDone())) {
            }
        }
    }

    private void restoreNextBuildNumber(File file, Integer toRestoreNextBuildNumber) throws IOException {
        String buildNumber = toRestoreNextBuildNumber + "\n";
        Files.writeString(file.toPath(), (CharSequence)buildNumber, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private Future<UpdateCenter.UpdateCenterJob> installPlugin(String pluginID, String version) {
        if (!(version.contains("SNAPSHOT") || "Hudson core".equals(pluginID) || "Jenkins core".equals(pluginID))) {
            Jenkins jenkins = Jenkins.get();
            UpdateCenter updateCenter = jenkins.getUpdateCenter();
            for (UpdateSite site : updateCenter.getSites()) {
                List<UpdateSite.Plugin> availablePlugins;
                if (this.availablePluginLocations.containsKey(site.getId())) {
                    availablePlugins = this.availablePluginLocations.get(site.getId());
                } else {
                    availablePlugins = site.getAvailables();
                    this.availablePluginLocations.put(site.getId(), availablePlugins);
                }
                for (UpdateSite.Plugin plugin : availablePlugins) {
                    if (!plugin.name.equals(pluginID)) continue;
                    LOGGER.log(Level.INFO, "Restore plugin ' {0} '.", pluginID);
                    if (!plugin.version.equals(version)) {
                        PluginRestoreUpdateCenter pruc;
                        jenkins.checkPermission(Jenkins.ADMINISTER);
                        PluginRestoreUpdateCenter pluginRestoreUpdateCenter = pruc = new PluginRestoreUpdateCenter();
                        Objects.requireNonNull(pluginRestoreUpdateCenter);
                        return pruc.addNewJob((UpdateCenter.UpdateCenterJob)new PluginRestoreUpdateCenter.PluginRestoreJob(pluginRestoreUpdateCenter, site, Jenkins.getAuthentication2(), plugin, version));
                    }
                    return plugin.deploy();
                }
            }
        }
        LOGGER.log(Level.WARNING, "Cannot find plugin ' {0} ' with the version ' {1} '. Please install manually!", new Object[]{pluginID, version});
        return null;
    }
}

