/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.DirectoryWalker;

public class DirectoriesZipper
extends DirectoryWalker<Object>
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    public static final int BUFFER_SIZE = 524288;
    private final ZipOutputStream zipStream;
    private final String rootPath;

    public DirectoriesZipper(File zipFile) throws IOException {
        if (!zipFile.createNewFile()) {
            LOGGER.log(Level.WARNING, "{0} already exists. Previous backup will be overridden.", zipFile.getName());
        }
        this.zipStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0])));
        this.rootPath = zipFile.getParent();
    }

    public void addToZip(File directory) throws IOException {
        this.walk(directory, Collections.emptyList());
    }

    @Override
    public void close() throws IOException {
        this.zipStream.close();
    }

    protected void handleFile(File file, int depth, Collection<Object> results) {
        try (FileInputStream fi = new FileInputStream(file);
             BufferedInputStream origin = new BufferedInputStream(fi);){
            int count;
            String entryPath = file.getAbsolutePath();
            entryPath = entryPath.replace(this.rootPath + File.separator, "");
            ZipEntry entry = new ZipEntry(entryPath);
            this.zipStream.putNextEntry(entry);
            byte[] buffer = new byte[524288];
            while ((count = origin.read(buffer)) != -1) {
                this.zipStream.write(buffer, 0, count);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Could not create ZIP entry", ioe);
        }
    }
}

