/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup;

import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.scheduler.CronTab;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.plugins.thinbackup.utils.EnvironmentVariableNotDefinedException;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"thinBackup"})
public class ThinBackupPluginImpl
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private String fullBackupSchedule = "";
    private String diffBackupSchedule = "";
    private String backupPath = "";
    private int nrMaxStoredFull = -1;
    private String excludedFilesRegex = null;
    private boolean waitForIdle = true;
    private int forceQuietModeTimeout = 120;
    private static final int VERY_HIGH_TIMEOUT = 720;
    private boolean cleanupDiff = false;
    private boolean moveOldBackupsToZipFile = false;
    private boolean backupBuildResults = true;
    private boolean backupBuildArchive = false;
    private boolean backupPluginArchives = false;
    private boolean backupUserContents = false;
    private boolean backupConfigHistory = false;
    private boolean backupAdditionalFiles = false;
    private String backupAdditionalFilesRegex = null;
    private boolean backupNextBuildNumber = false;
    private boolean backupBuildsToKeepOnly = false;
    private boolean failFast = true;

    @DataBoundConstructor
    public ThinBackupPluginImpl() {
        File oldConfig = new File(Jenkins.get().getRootDir(), "thinBackup.xml");
        File newConfig = this.getConfigFile().getFile();
        boolean oldConfigExists = oldConfig.exists();
        boolean newConfigExits = newConfig.exists();
        if (oldConfigExists && !newConfigExits) {
            LOGGER.warning("old config of 'thinBackup' detected, moving to new name");
            try {
                Files.move(oldConfig.toPath(), newConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.severe("unable to move old config to new config, you will need to reconfigure thinBackup plugin manually");
            }
        }
        this.load();
        LOGGER.fine("'thinBackup' plugin initialized.");
    }

    public static ThinBackupPluginImpl get() {
        return (ThinBackupPluginImpl)((Object)ExtensionList.lookupSingleton(ThinBackupPluginImpl.class));
    }

    public File getJenkinsHome() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.getRootDir();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try (BulkChange bc = new BulkChange((Saveable)this);){
            req.bindJSON((Object)this, json);
            bc.commit();
        }
        catch (IOException e) {
            throw new Descriptor.FormException((Throwable)e, "thinBackup");
        }
        return true;
    }

    @DataBoundSetter
    public void setFullBackupSchedule(String fullBackupSchedule) {
        this.fullBackupSchedule = fullBackupSchedule;
        this.save();
    }

    public String getFullBackupSchedule() {
        return this.fullBackupSchedule;
    }

    @DataBoundSetter
    public void setDiffBackupSchedule(String diffBackupSchedule) {
        this.diffBackupSchedule = diffBackupSchedule;
        this.save();
    }

    public String getDiffBackupSchedule() {
        return this.diffBackupSchedule;
    }

    public int getForceQuietModeTimeout() {
        return this.forceQuietModeTimeout;
    }

    @DataBoundSetter
    public void setForceQuietModeTimeout(int forceQuietModeTimeout) {
        this.forceQuietModeTimeout = forceQuietModeTimeout;
        this.save();
    }

    @DataBoundSetter
    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
        this.save();
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public String getExpandedBackupPath() {
        String expandedPath = "";
        try {
            expandedPath = Utils.expandEnvironmentVariables(this.backupPath);
        }
        catch (EnvironmentVariableNotDefinedException evnde) {
            LOGGER.log(Level.SEVERE, evnde.getMessage() + " Using unexpanded path.");
            expandedPath = this.backupPath;
        }
        return expandedPath;
    }

    @DataBoundSetter
    public void setNrMaxStoredFull(int nrMaxStoredFull) {
        this.nrMaxStoredFull = nrMaxStoredFull;
        this.save();
    }

    public int getNrMaxStoredFull() {
        return this.nrMaxStoredFull;
    }

    @DataBoundSetter
    public void setCleanupDiff(boolean cleanupDiff) {
        this.cleanupDiff = cleanupDiff;
        this.save();
    }

    public boolean isCleanupDiff() {
        return this.cleanupDiff;
    }

    @DataBoundSetter
    public void setMoveOldBackupsToZipFile(boolean moveOldBackupsToZipFile) {
        this.moveOldBackupsToZipFile = moveOldBackupsToZipFile;
        this.save();
    }

    public boolean isMoveOldBackupsToZipFile() {
        return this.moveOldBackupsToZipFile;
    }

    @DataBoundSetter
    public void setBackupBuildResults(boolean backupBuildResults) {
        this.backupBuildResults = backupBuildResults;
        this.save();
    }

    public boolean isBackupBuildResults() {
        return this.backupBuildResults;
    }

    @DataBoundSetter
    public void setBackupBuildArchive(boolean backupBuildArchive) {
        this.backupBuildArchive = backupBuildArchive;
        this.save();
    }

    public boolean isBackupBuildArchive() {
        return this.backupBuildArchive;
    }

    @DataBoundSetter
    public void setBackupBuildsToKeepOnly(boolean backupBuildsToKeepOnly) {
        this.backupBuildsToKeepOnly = backupBuildsToKeepOnly;
        this.save();
    }

    public boolean isBackupBuildsToKeepOnly() {
        return this.backupBuildsToKeepOnly;
    }

    @DataBoundSetter
    public void setBackupNextBuildNumber(boolean backupNextBuildNumber) {
        this.backupNextBuildNumber = backupNextBuildNumber;
        this.save();
    }

    public boolean isBackupNextBuildNumber() {
        return this.backupNextBuildNumber;
    }

    @DataBoundSetter
    public void setExcludedFilesRegex(String excludedFilesRegex) {
        this.excludedFilesRegex = excludedFilesRegex;
        this.save();
    }

    public boolean isBackupUserContents() {
        return this.backupUserContents;
    }

    @DataBoundSetter
    public void setBackupUserContents(boolean backupUserContents) {
        this.backupUserContents = backupUserContents;
        this.save();
    }

    public String getExcludedFilesRegex() {
        return this.excludedFilesRegex;
    }

    @DataBoundSetter
    public void setBackupPluginArchives(boolean backupPluginArchives) {
        this.backupPluginArchives = backupPluginArchives;
        this.save();
    }

    public boolean isBackupPluginArchives() {
        return this.backupPluginArchives;
    }

    @DataBoundSetter
    public void setBackupAdditionalFiles(boolean backupAdditionalFiles) {
        this.backupAdditionalFiles = backupAdditionalFiles;
        this.save();
    }

    public boolean isBackupAdditionalFiles() {
        return this.backupAdditionalFiles;
    }

    @DataBoundSetter
    public void setBackupAdditionalFilesRegex(String backupAdditionalFilesRegex) {
        this.backupAdditionalFilesRegex = backupAdditionalFilesRegex;
        this.save();
    }

    public String getBackupAdditionalFilesRegex() {
        return this.backupAdditionalFilesRegex;
    }

    @DataBoundSetter
    public void setWaitForIdle(boolean waitForIdle) {
        this.waitForIdle = waitForIdle;
        this.save();
    }

    public boolean isWaitForIdle() {
        return this.waitForIdle;
    }

    public boolean isBackupConfigHistory() {
        return this.backupConfigHistory;
    }

    @DataBoundSetter
    public void setBackupConfigHistory(boolean backupConfigHistory) {
        this.backupConfigHistory = backupConfigHistory;
        this.save();
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    @DataBoundSetter
    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public FormValidation doCheckBackupPath(@QueryParameter String value) {
        File backupdir;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (value == null || value.trim().isEmpty()) {
            return FormValidation.error((String)"Backup path must not be empty.");
        }
        String expandedPathMessage = "";
        String expandedPath = "";
        try {
            expandedPath = Utils.expandEnvironmentVariables(value);
        }
        catch (EnvironmentVariableNotDefinedException evnd) {
            return FormValidation.error((String)evnd.getMessage());
        }
        if (!expandedPath.equals(value)) {
            expandedPathMessage = String.format("The path will be expanded to '%s'.%n%n", expandedPath);
        }
        if (!(backupdir = new File(expandedPath)).exists()) {
            return FormValidation.warning((String)(expandedPathMessage + "The directory does not exist, but will be created before the first run."));
        }
        if (!backupdir.isDirectory()) {
            return FormValidation.error((String)(expandedPathMessage + "A file with this name exists, thus a directory with the same name cannot be created."));
        }
        File tmp = new File(expandedPath + File.separator + "test.txt");
        try {
            tmp.createNewFile();
        }
        catch (Exception e) {
            if (!tmp.canWrite()) {
                FormValidation formValidation = FormValidation.error((String)(expandedPathMessage + "The directory exists, but is not writable."));
                return formValidation;
            }
        }
        finally {
            boolean deleted;
            if (tmp.exists() && !(deleted = tmp.delete())) {
                LOGGER.log(Level.WARNING, "Temp-file " + tmp.getAbsolutePath() + " could not be deleted.");
            }
        }
        if (!expandedPath.trim().equals(expandedPath)) {
            return FormValidation.warning((String)(expandedPathMessage + "Path contains leading and/or trailing whitespaces - is this intentional?"));
        }
        if (!expandedPathMessage.isEmpty()) {
            return FormValidation.warning((String)expandedPathMessage.substring(0, expandedPathMessage.length() - 2));
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doCheckFullBackupSchedule(@QueryParameter(value="value") String schedule) {
        return this.checkBackupSchedule(schedule);
    }

    @POST
    public FormValidation doCheckDiffBackupSchedule(@QueryParameter(value="value") String schedule) {
        return this.checkBackupSchedule(schedule);
    }

    private FormValidation checkBackupSchedule(String schedule) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (schedule != null && !schedule.isEmpty()) {
            String message;
            try {
                message = new CronTab(schedule).checkSanity();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)("Invalid cron schedule. " + e.getMessage()));
            }
            if (message != null) {
                return FormValidation.warning((String)("Cron schedule warning: " + message));
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doCheckExcludedFilesRegex(@QueryParameter(value="value") String regex) {
        return this.checkCronSytax(regex);
    }

    @POST
    public FormValidation doCheckBackupAdditionalFilesRegex(@QueryParameter(value="value") String regex) {
        return this.checkCronSytax(regex);
    }

    private FormValidation checkCronSytax(String regex) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (regex == null || regex.isEmpty()) {
            return FormValidation.ok();
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException pse) {
            return FormValidation.error((String)"Regex syntax is invalid.");
        }
        if (regex.trim().isEmpty()) {
            return FormValidation.warning((String)"Regex is valid, but consists entirely of whitespaces - is this intentional?");
        }
        if (!regex.trim().equals(regex)) {
            return FormValidation.warning((String)"Regex is valid, but contains leading and/or trailing whitespaces - is this intentional?");
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doCheckWaitForIdle(@QueryParameter(value="value") String waitForIdle) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (Boolean.parseBoolean(waitForIdle)) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"This may or may not generate corrupt backups! Be aware that no data get changed during the backup process!");
    }

    @POST
    public FormValidation doCheckForceQuietModeTimeout(@QueryParameter(value="value") String timeout) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FormValidation validation = FormValidation.validateIntegerInRange((String)timeout, (int)-1, (int)Integer.MAX_VALUE);
        if (!FormValidation.ok().equals(validation)) {
            return validation;
        }
        int intTimeout = Integer.parseInt(timeout);
        if (intTimeout > 720) {
            return FormValidation.warning((String)"You choose a very long timeout. The value need to be in minutes.");
        }
        return FormValidation.ok();
    }
}

