/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPluginImpl;
import org.jvnet.hudson.plugins.thinbackup.restore.HudsonRestore;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
public class ThinBackupMgmtLink
extends ManagementLink {
    private static final String THIN_BACKUP_SUBPATH = "/thinBackup";
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");

    public String getDisplayName() {
        return "ThinBackup";
    }

    public String getIconFileName() {
        return "symbol-archive-outline plugin-ionicons-api";
    }

    public String getUrlName() {
        return "thinBackup";
    }

    public String getDescription() {
        return "Backup your global and job specific configuration.";
    }

    @POST
    public void doBackupManual(StaplerRequest2 res, StaplerResponse2 rsp) throws IOException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        LOGGER.info("Starting manual backup.");
        ThinBackupPeriodicWork manualBackupWorker = new ThinBackupPeriodicWork(){

            @Override
            protected void execute(TaskListener arg0) {
                this.backupNow(ThinBackupPeriodicWork.BackupType.FULL);
            }
        };
        Timer.get().schedule((Runnable)((Object)manualBackupWorker), 0L, TimeUnit.SECONDS);
        rsp.sendRedirect(res.getContextPath() + THIN_BACKUP_SUBPATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public void doRestore(StaplerRequest2 res, StaplerResponse2 rsp, @QueryParameter(value="restoreBackupFrom") String restoreBackupFrom, @QueryParameter(value="restoreNextBuildNumber") String restoreNextBuildNumber, @QueryParameter(value="restorePlugins") String restorePlugins) throws IOException {
        LOGGER.info("Starting restore operation.");
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        jenkins.doQuietDown();
        LOGGER.fine("Waiting until executors are idle to perform restore...");
        Utils.waitUntilIdle();
        try {
            File jenkinsHome = jenkins.getRootDir();
            Date restoreFromDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(restoreBackupFrom);
            HudsonRestore hudsonRestore = new HudsonRestore(jenkinsHome, ThinBackupPluginImpl.get().getExpandedBackupPath(), restoreFromDate, "on".equals(restoreNextBuildNumber), "on".equals(restorePlugins));
            hudsonRestore.restore();
            LOGGER.info("Restore finished.");
        }
        catch (ParseException e) {
            LOGGER.severe("Cannot parse restore option. Aborting.");
        }
        catch (Exception ise) {
            LOGGER.severe("Could not restore. Aborting.");
        }
        finally {
            jenkins.doCancelQuietDown();
            rsp.sendRedirect(res.getContextPath() + THIN_BACKUP_SUBPATH);
        }
    }

    public ThinBackupPluginImpl getConfiguration() {
        return ThinBackupPluginImpl.get();
    }

    public List<String> getAvailableBackups() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.get();
        return Utils.getBackupsAsDates(new File(plugin.getExpandedBackupPath()));
    }

    @POST
    public ListBoxModel doFillBackupItems() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ThinBackupPluginImpl plugin = ThinBackupPluginImpl.get();
        List<String> backupsAsDates = Utils.getBackupsAsDates(new File(plugin.getExpandedBackupPath()));
        ListBoxModel model = new ListBoxModel();
        for (String entry : backupsAsDates) {
            model.add((Object)new ListBoxModel.Option(entry));
        }
        return model;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.TOOLS;
    }
}

