/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.backup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.backup.DirectoriesZipper;
import org.jvnet.hudson.plugins.thinbackup.utils.Utils;

public class BackupSet
implements Comparable<BackupSet> {
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    public static final String BACKUPSET_ZIPFILE_PREFIX = "BACKUPSET";
    private boolean inZipFile = false;
    private File backupSetzipFile = null;
    private File unzipDir = null;
    private File fullBackup = null;
    private String fullBackupName = null;
    private List<File> diffBackups = null;
    private List<String> diffBackupsNames;

    public BackupSet(File initial) {
        boolean success = false;
        String name = initial.getName();
        if (name.startsWith(BACKUPSET_ZIPFILE_PREFIX) && name.endsWith(".zip")) {
            this.inZipFile = true;
            this.backupSetzipFile = initial;
        } else if (name.startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString())) {
            this.fullBackup = initial;
        } else if (name.startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
            this.fullBackup = Utils.getReferencedFullBackup(initial);
        }
        success = this.initialize();
        if (!success && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning(String.format("Could not initialize backup set from file/directory '%s' as it is not valid.", name));
        }
    }

    private boolean initialize() {
        boolean success = false;
        this.diffBackupsNames = new ArrayList<String>();
        success = this.inZipFile ? this.initializeFromZipFile() : this.initializeFromDirs();
        if (!success) {
            this.fullBackup = null;
            this.fullBackupName = null;
            if (this.diffBackups != null) {
                this.diffBackups.clear();
            }
            this.diffBackups = null;
            if (this.diffBackupsNames != null) {
                this.diffBackupsNames.clear();
            }
            this.diffBackupsNames = null;
        }
        if (success && this.diffBackupsNames != null) {
            Collections.sort(this.diffBackupsNames);
        }
        return success;
    }

    private boolean initializeFromZipFile() {
        boolean success = true;
        try (ZipFile zipFile = new ZipFile(this.backupSetzipFile);){
            Utils.waitUntilFileCanBeRead(this.backupSetzipFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements() && success) {
                ZipEntry entry = zipEntries.nextElement();
                String tmpName = entry.getName();
                if ((tmpName = tmpName.substring(0, tmpName.indexOf(File.separator))).startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString())) {
                    if (this.fullBackupName == null || this.fullBackupName.equals(tmpName)) {
                        this.fullBackupName = tmpName;
                        continue;
                    }
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(String.format("Backup set '%s' contains multiple full backups and is therefore not valid.", zipFile.getName()));
                    }
                    success = false;
                    continue;
                }
                if (!tmpName.startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString()) || this.diffBackupsNames.contains(tmpName)) continue;
                this.diffBackupsNames.add(tmpName);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, String.format("Cannot initialize BackupSet from ZIP file '%s'.", this.backupSetzipFile.getName()), e);
            success = false;
        }
        return success;
    }

    private boolean initializeFromDirs() {
        boolean success = false;
        if (this.fullBackup != null) {
            this.fullBackupName = this.fullBackup.getName();
            this.diffBackups = Utils.getReferencingDiffBackups(this.fullBackup);
            success = true;
        }
        if (success && !this.diffBackups.isEmpty()) {
            this.diffBackupsNames = new ArrayList<String>(this.diffBackups.size());
            for (File diffBackup : this.diffBackups) {
                String tmpName = diffBackup.getName();
                if (!this.diffBackupsNames.contains(tmpName)) {
                    this.diffBackupsNames.add(tmpName);
                    continue;
                }
                LOGGER.warning("Backup set contains multiple diff backups with the same name. This is not allowed; backup set is invalid.");
                success = false;
            }
        }
        return success;
    }

    public boolean isValid() {
        return this.fullBackupName != null;
    }

    public void delete() throws IOException {
        if (this.isValid()) {
            if (!this.inZipFile) {
                if (this.fullBackup != null) {
                    FileUtils.deleteDirectory((File)this.fullBackup);
                    this.fullBackup = null;
                }
                if (this.diffBackups != null) {
                    for (File diffBackup : this.diffBackups) {
                        FileUtils.deleteDirectory((File)diffBackup);
                    }
                    this.diffBackups = null;
                }
            } else {
                FileUtils.deleteQuietly((File)this.backupSetzipFile);
                this.deleteUnzipDir();
            }
        }
    }

    public void deleteUnzipDir() {
        if (this.unzipDir != null && this.unzipDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.unzipDir);
            }
            catch (IOException e) {
                LOGGER.warning(String.format("Could not delete unzipping directory '%s'. Please delete manually.", this.unzipDir.getAbsolutePath()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FULL backup: ");
        sb.append(Objects.requireNonNullElse(this.fullBackupName, "NONE"));
        sb.append("; DIFF backups: ");
        boolean hasDiffs = false;
        if (this.diffBackupsNames != null) {
            for (String diffBackup : this.diffBackupsNames) {
                sb.append(diffBackup);
                sb.append(",");
            }
            if (!this.diffBackupsNames.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
                hasDiffs = true;
            }
        }
        if (!hasDiffs) {
            sb.append("NONE");
        }
        sb.append("]");
        return sb.toString();
    }

    public BackupSet unzip() throws IOException {
        BackupSet result = null;
        result = this.inZipFile && this.isValid() ? this.unzipTo(new File(Utils.THINBACKUP_TMP_DIR)) : this;
        return result;
    }

    public BackupSet unzipTo(File directory) throws IOException {
        BackupSet result = null;
        if (this.inZipFile && this.isValid()) {
            boolean dirCreationResult;
            if (!directory.exists() && !(dirCreationResult = directory.mkdirs())) {
                LOGGER.log(Level.WARNING, "Unable to create following directory during unzip: " + directory.getAbsolutePath());
            }
            this.unzipDir = new File(directory, this.getBackupSetZipFileName().replace(".zip", ""));
            if (!this.unzipDir.exists() && !this.unzipDir.mkdirs()) {
                LOGGER.log(Level.WARNING, "Unable to create following directory during unzip: " + this.unzipDir.getAbsolutePath());
            }
            try (ZipFile zipFile = new ZipFile(this.backupSetzipFile);){
                byte[] data = new byte[524288];
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    boolean dirCreationResult2;
                    ZipEntry entry = zipEntries.nextElement();
                    String fullPathToEntry = entry.getName();
                    String pathToEntry = fullPathToEntry.substring(0, fullPathToEntry.lastIndexOf(File.separator));
                    File entryDir = new File(this.unzipDir, pathToEntry);
                    if (!entryDir.exists() && !(dirCreationResult2 = entryDir.mkdirs())) {
                        LOGGER.log(Level.WARNING, "Unable to create following directory during unzip: " + entryDir.getAbsolutePath());
                    }
                    String entryName = fullPathToEntry.substring(fullPathToEntry.lastIndexOf(File.separator) + 1);
                    try (FileOutputStream fos = new FileOutputStream(new File(String.valueOf(this.unzipDir) + File.separator + pathToEntry, entryName));
                         BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                         BufferedOutputStream dest = new BufferedOutputStream(fos, 524288);){
                        int count = 0;
                        while ((count = is.read(data)) != -1) {
                            dest.write(data, 0, count);
                        }
                        dest.flush();
                    }
                }
            }
            File[] backups = this.unzipDir.listFiles();
            result = backups != null && backups.length > 0 ? new BackupSet(backups[0]) : new BackupSet(this.unzipDir);
        } else {
            result = this;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File zipTo(File directory) {
        File zipFile = null;
        if (this.isValid()) {
            if (!this.inZipFile) {
                DirectoriesZipper zipper = null;
                try {
                    boolean success;
                    if (!directory.exists() && !(success = directory.mkdirs())) {
                        throw new IOException(String.format("Could not create directory '%s'.", directory.getAbsolutePath()));
                    }
                    String zipFileName = this.getBackupSetZipFileName();
                    zipFile = new File(directory, zipFileName);
                    zipper = new DirectoriesZipper(zipFile);
                    zipper.addToZip(this.getFullBackup());
                    for (File diffBackup : this.getDiffBackups()) {
                        zipper.addToZip(diffBackup);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.SEVERE, "Could not zip backup set.", ioe);
                }
                finally {
                    try {
                        if (zipper != null) {
                            zipper.close();
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.SEVERE, "Could not zip backup set.", ioe);
                    }
                }
            } else {
                zipFile = this.backupSetzipFile;
            }
        }
        return zipFile;
    }

    private String getBackupSetZipFileName() {
        return String.format("%s_%s_%s%s", BACKUPSET_ZIPFILE_PREFIX, this.getFormattedFullBackupDate(), this.getFormattedLatestDiffBackupDate(), ".zip");
    }

    private String getFormattedFullBackupDate() {
        String result = "";
        Date tmp = Utils.getDateFromBackupDirectoryName(this.fullBackupName);
        if (tmp != null) {
            result = new SimpleDateFormat("yyyy-MM-dd_HH-mm").format(tmp);
        }
        return result;
    }

    private String getFormattedLatestDiffBackupDate() {
        Date tmp;
        String result = "";
        if (this.diffBackupsNames != null && !this.diffBackupsNames.isEmpty() && (tmp = Utils.getDateFromBackupDirectoryName(this.diffBackupsNames.get(this.diffBackupsNames.size() - 1))) != null) {
            result = new SimpleDateFormat("yyyy-MM-dd_HH-mm").format(tmp);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSet backupSet = (BackupSet)o;
        return Objects.equals(this.fullBackupName, backupSet.fullBackupName);
    }

    public int hashCode() {
        return Objects.hash(this.fullBackupName);
    }

    @Override
    public int compareTo(BackupSet other) {
        String otherFullBackupName = other.getFullBackupName();
        if (other == this || this.fullBackupName == null && otherFullBackupName == null) {
            return 0;
        }
        if (this.fullBackupName == null) {
            return -1;
        }
        if (otherFullBackupName == null) {
            return 1;
        }
        return this.fullBackupName.compareTo(otherFullBackupName);
    }

    public boolean containsDirectory(File directory) {
        boolean inDiffs;
        String directoryName;
        block2: {
            String diffBackupName;
            if (directory == null || !directory.isDirectory() || !this.isValid()) {
                return false;
            }
            directoryName = directory.getName();
            inDiffs = false;
            if (this.diffBackupsNames == null) break block2;
            Iterator<String> iterator = this.diffBackupsNames.iterator();
            while (iterator.hasNext() && !(inDiffs = directoryName.equals(diffBackupName = iterator.next()))) {
            }
        }
        return inDiffs || directoryName.equals(this.fullBackupName);
    }

    public boolean containsBackupForDate(Date date) {
        if (date == null || !this.isValid()) {
            return false;
        }
        Date tmp = null;
        boolean inDiffs = false;
        if (this.diffBackupsNames != null) {
            String diffBackupName;
            Iterator<String> iterator = this.diffBackupsNames.iterator();
            while (iterator.hasNext() && !(inDiffs = date.equals(tmp = Utils.getDateFromBackupDirectoryName(diffBackupName = iterator.next())))) {
            }
        }
        tmp = Utils.getDateFromBackupDirectoryName(this.fullBackupName);
        return inDiffs || date.equals(tmp);
    }

    public boolean isInZipFile() {
        return this.inZipFile;
    }

    public File getFullBackup() {
        return this.fullBackup;
    }

    public String getFullBackupName() {
        return this.fullBackupName;
    }

    public List<File> getDiffBackups() {
        return this.diffBackups;
    }

    public List<String> getDiffBackupsNames() {
        return this.diffBackupsNames;
    }

    public File getUnzipDir() {
        return this.unzipDir;
    }
}

