/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Computer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jvnet.hudson.plugins.thinbackup.ThinBackupPeriodicWork;
import org.jvnet.hudson.plugins.thinbackup.backup.BackupSet;
import org.jvnet.hudson.plugins.thinbackup.utils.EnvironmentVariableNotDefinedException;

public final class Utils {
    private static final int SLEEP_TIMEOUT = 500;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.thinbackup");
    private static final int QUIETMODE_MONITORING_SLEEP = 500;
    private static final String DIRECTORY_NAME_DATE_EXTRACTION_REGEX = String.format("(%s|%s)-", new Object[]{ThinBackupPeriodicWork.BackupType.FULL, ThinBackupPeriodicWork.BackupType.DIFF});
    private static final String START_ENV_VAR_TOKEN = "${";
    private static final String END_ENV_VAR_TOKEN = "}";
    public static final String DISPLAY_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DIRECTORY_NAME_DATE_FORMAT = "yyyy-MM-dd_HH-mm";
    public static final String THINBACKUP_TMP_DIR = System.getProperty("java.io.tmpdir") + File.separator + "thinBackupTmpDir";
    public static final int FORCE_QUIETMODE_TIMEOUT_MINUTES = 120;

    private Utils() {
    }

    public static void waitUntilIdle() {
        boolean running;
        Jenkins jenkins = Jenkins.get();
        Computer[] computers = jenkins.getComputers();
        do {
            running = false;
            for (Computer computer : computers) {
                if (computer.countBusy() == 0) continue;
                running = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                Thread.currentThread().interrupt();
            }
        } while (running);
    }

    public static void waitUntilIdleAndSwitchToQuietMode(int timeout, TimeUnit unit) throws IOException {
        boolean running;
        Jenkins jenkins = Jenkins.get();
        Computer[] computers = jenkins.getComputers();
        long starttime = System.currentTimeMillis();
        do {
            running = false;
            for (Computer computer : computers) {
                if (computer.countBusy() == 0) continue;
                running = true;
                break;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                Thread.currentThread().interrupt();
            }
            if (timeout == -1 || jenkins.isQuietingDown() || starttime + unit.toMillis(timeout) >= System.currentTimeMillis()) continue;
            LOGGER.info("Force quiet mode for jenkins now and wait until all executors are idle.");
            jenkins.doQuietDown();
        } while (running);
    }

    public static Date getDateFromBackupDirectory(File directory) {
        return Utils.getDateFromBackupDirectoryName(directory.getName());
    }

    public static Date getDateFromBackupDirectoryName(String directoryName) {
        Date result = null;
        String dateOnly = "";
        try {
            if ((directoryName.startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString()) || directoryName.startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) && !(dateOnly = directoryName.replaceFirst(DIRECTORY_NAME_DATE_EXTRACTION_REGEX, "")).isEmpty()) {
                result = new SimpleDateFormat(DIRECTORY_NAME_DATE_FORMAT).parse(dateOnly);
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.FINEST, "Unexplained NFE...", nfe);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Could not parse directory name '%s'.", directoryName));
        }
        return result;
    }

    public static String convertToDirectoryNameDateFormat(String displayFormattedDate) throws ParseException {
        Date displayDate = new SimpleDateFormat(DISPLAY_DATE_FORMAT).parse(displayFormattedDate);
        return new SimpleDateFormat(DIRECTORY_NAME_DATE_FORMAT).format(displayDate);
    }

    public static File getFormattedDirectory(File parent, ThinBackupPeriodicWork.BackupType backupType, Date date) {
        return new File(parent, String.format("%s-%s", new Object[]{backupType, new SimpleDateFormat(DIRECTORY_NAME_DATE_FORMAT).format(date)}));
    }

    public static List<File> getBackupTypeDirectories(File parentDir, ThinBackupPeriodicWork.BackupType backupType) {
        IOFileFilter prefixFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)backupType.toString()), DirectoryFileFilter.DIRECTORY});
        File[] existingDirs = parentDir.listFiles((FilenameFilter)prefixFilter);
        if (existingDirs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(existingDirs);
    }

    public static List<File> getBackupSetZipFiles(File parentDir) {
        IOFileFilter zipFileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"BACKUPSET"), FileFilterUtils.suffixFileFilter((String)".zip"), FileFileFilter.INSTANCE});
        File[] existingZips = parentDir.listFiles((FilenameFilter)zipFileFilter);
        if (existingZips == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(existingZips);
    }

    public static File getReferencedFullBackup(File diffBackup) {
        if (diffBackup.getName().startsWith(ThinBackupPeriodicWork.BackupType.FULL.toString())) {
            return diffBackup;
        }
        List<File> backups = Utils.getBackupTypeDirectories(diffBackup.getParentFile(), ThinBackupPeriodicWork.BackupType.FULL);
        if (backups.isEmpty()) {
            return null;
        }
        File referencedFullBackup = null;
        Date curBackupDate = Utils.getDateFromBackupDirectory(diffBackup);
        if (curBackupDate != null) {
            Date closestPreviousBackupDate = new Date(0L);
            for (File fullBackupDir : backups) {
                Date tmpBackupDate = Utils.getDateFromBackupDirectory(fullBackupDir);
                if (tmpBackupDate == null || !tmpBackupDate.after(closestPreviousBackupDate) || tmpBackupDate.getTime() > curBackupDate.getTime()) continue;
                closestPreviousBackupDate = tmpBackupDate;
                referencedFullBackup = fullBackupDir;
            }
        }
        return referencedFullBackup;
    }

    @NonNull
    public static List<File> getReferencingDiffBackups(File fullBackup) {
        ArrayList<File> diffBackups = new ArrayList<File>();
        if (fullBackup.getName().startsWith(ThinBackupPeriodicWork.BackupType.DIFF.toString())) {
            return diffBackups;
        }
        List<File> allDiffBackups = Utils.getBackupTypeDirectories(fullBackup.getParentFile(), ThinBackupPeriodicWork.BackupType.DIFF);
        for (File diffBackup : allDiffBackups) {
            File tmpFullBackup = Utils.getReferencedFullBackup(diffBackup);
            if (tmpFullBackup == null || !tmpFullBackup.getAbsolutePath().equals(fullBackup.getAbsolutePath())) continue;
            diffBackups.add(diffBackup);
        }
        return diffBackups;
    }

    public static List<String> getBackupsAsDates(File directory) {
        ArrayList<String> backupDates = new ArrayList<String>();
        List<BackupSet> backupSets = Utils.getValidBackupSets(directory);
        for (BackupSet backupSet : backupSets) {
            String fullName = backupSet.getFullBackupName();
            try {
                Date tmp = Utils.getDateFromBackupDirectoryName(fullName);
                if (tmp == null) {
                    throw new ParseException("", 0);
                }
                backupDates.add(new SimpleDateFormat(DISPLAY_DATE_FORMAT).format(tmp));
            }
            catch (ParseException e) {
                LOGGER.warning(String.format("Cannot parse directory name '%s' , therefore it will not show up in the list of available backups.", fullName));
            }
            for (String diffName : backupSet.getDiffBackupsNames()) {
                try {
                    Date tmp = Utils.getDateFromBackupDirectoryName(diffName);
                    if (tmp != null) {
                        backupDates.add(new SimpleDateFormat(DISPLAY_DATE_FORMAT).format(tmp));
                        continue;
                    }
                    throw new ParseException("", 0);
                }
                catch (ParseException e) {
                    LOGGER.warning(String.format("Cannot parse directory name '%s' , therefore it will not show up in the list of available backups.", diffName));
                }
            }
        }
        Collections.sort(backupDates);
        Collections.reverse(backupDates);
        return backupDates;
    }

    public static List<BackupSet> getValidBackupSetsFromDirectories(File directory) {
        List<File> backups = Utils.getBackupTypeDirectories(directory, ThinBackupPeriodicWork.BackupType.FULL);
        ArrayList<BackupSet> validSets = new ArrayList<BackupSet>();
        for (File backup : backups) {
            BackupSet set = new BackupSet(backup);
            if (!set.isValid()) continue;
            validSets.add(set);
        }
        Collections.sort(validSets);
        return validSets;
    }

    public static List<BackupSet> getValidBackupSetsFromZips(File directory) {
        List<File> backups = Utils.getBackupSetZipFiles(directory);
        ArrayList<BackupSet> validSets = new ArrayList<BackupSet>();
        for (File backup : backups) {
            BackupSet set = new BackupSet(backup);
            if (!set.isValid()) continue;
            validSets.add(set);
        }
        Collections.sort(validSets);
        return validSets;
    }

    public static List<BackupSet> getValidBackupSets(File directory) {
        ArrayList<BackupSet> validSets = new ArrayList<BackupSet>();
        validSets.addAll(Utils.getValidBackupSetsFromDirectories(directory));
        validSets.addAll(Utils.getValidBackupSetsFromZips(directory));
        Collections.sort(validSets);
        return validSets;
    }

    public static void moveOldBackupsToZipFile(File backupRoot, File currentBackup) {
        LOGGER.fine("Moving old backups to zip files...");
        List<BackupSet> validBackupSets = Utils.getValidBackupSetsFromDirectories(backupRoot);
        int numberOfZippedBackupSets = 0;
        int numberOfMovedBackupSets = 0;
        for (BackupSet backupSet : validBackupSets) {
            if (backupSet.containsDirectory(currentBackup) || backupSet.isInZipFile()) continue;
            File zippedBackupSet = backupSet.zipTo(backupRoot);
            ++numberOfZippedBackupSets;
            if (zippedBackupSet == null) continue;
            LOGGER.fine(String.format("Successfully zipped backup set %s to '%s'.", backupSet, zippedBackupSet.getAbsolutePath()));
            try {
                backupSet.delete();
                LOGGER.fine(String.format("Deleted backup set %s after zipping it.", backupSet));
                ++numberOfMovedBackupSets;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, String.format("Could not delete backup set %s.", backupSet));
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            if (numberOfMovedBackupSets == numberOfZippedBackupSets) {
                LOGGER.info(String.format("DONE moving %d backup set(s) to ZIP files.", numberOfMovedBackupSets));
            } else {
                LOGGER.info(String.format("DONE zipping %d backup set(s). %d of those could be moved to ZIP files, the rest remain as files/directories as well.", numberOfZippedBackupSets, numberOfMovedBackupSets));
            }
        }
    }

    public static String expandEnvironmentVariables(String path) throws EnvironmentVariableNotDefinedException {
        return Utils.internalExpandEnvironmentVariables(path, System.getenv());
    }

    protected static String internalExpandEnvironmentVariables(String path, Map<String, String> environmentVariables) throws EnvironmentVariableNotDefinedException {
        String tmpPath = path;
        StringBuilder newPath = new StringBuilder();
        boolean done = false;
        while (!done) {
            if (tmpPath.contains(START_ENV_VAR_TOKEN)) {
                int startIdx = tmpPath.indexOf(START_ENV_VAR_TOKEN);
                int endIdx = tmpPath.indexOf(END_ENV_VAR_TOKEN, startIdx + START_ENV_VAR_TOKEN.length());
                if (endIdx != -1) {
                    String envVar = tmpPath.substring(startIdx + START_ENV_VAR_TOKEN.length(), endIdx);
                    String envVarValue = environmentVariables.get(envVar);
                    if (envVarValue == null) {
                        String message = String.format("Environment variable '%s' was specified in path '%s', but it is not defined in the system's environment variables.", envVar, path);
                        throw new EnvironmentVariableNotDefinedException(message);
                    }
                    newPath.append(tmpPath, 0, startIdx);
                    newPath.append(envVarValue);
                    tmpPath = tmpPath.substring(endIdx + END_ENV_VAR_TOKEN.length());
                } else {
                    newPath.append(tmpPath);
                    done = true;
                }
                if (!tmpPath.isEmpty()) continue;
                done = true;
                continue;
            }
            newPath.append(tmpPath);
            done = true;
        }
        return newPath.toString();
    }

    public static void waitUntilFileCanBeRead(File f) {
        while (!f.canRead()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

