/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.thinbackup.restore;

import hudson.PluginManager;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;

public class PluginRestoreUpdateCenter
extends UpdateCenter {
    private Set<UpdateSite> knownUpdateSites = new HashSet<UpdateSite>();

    synchronized Future<UpdateCenter.UpdateCenterJob> addNewJob(UpdateCenter.UpdateCenterJob job) {
        if (this.knownUpdateSites.add(job.site)) {
            new UpdateCenter.ConnectionCheckJob((UpdateCenter)this, job.site).submit();
        }
        return job.submit();
    }

    public class PluginRestoreJob
    extends UpdateCenter.DownloadJob {
        private UpdateSite.Plugin plugin;
        private String version;
        private final PluginManager pm;

        public PluginRestoreJob(UpdateSite site, Authentication auth, UpdateSite.Plugin plugin, String version) {
            super((UpdateCenter)PluginRestoreUpdateCenter.this, site, auth);
            this.plugin = plugin;
            this.version = version;
            Jenkins jenkins = Jenkins.get();
            this.pm = jenkins.getPluginManager();
        }

        protected URL getURL() throws MalformedURLException {
            String latestVersion = this.plugin.version;
            String newUrl = this.plugin.url.replace(latestVersion, this.version);
            return new URL(newUrl);
        }

        protected File getDestination() {
            return new File(this.pm.rootDir, this.plugin.name + ".hpi");
        }

        public String getName() {
            return this.plugin.getDisplayName();
        }

        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }

        protected void _run() throws IOException, UpdateCenter.DownloadJob.InstallationStatus {
            super._run();
        }
    }
}

